#include<stdio.h>
#include<math.h>
/* #include"ulaw.h"     /* ulaw to linear conversion table from voxware  */
                     /* device driver   */

unsigned short int docrc(unsigned char *);

/*
#define DEBUG   
#define SHOWBYTES 
#define SHOWBITS     
*/

/* protocol version: */
#define VERSION2

/* bit clock, in samples */
#define CLOCK 22

/* amplitude delta to call it a spike */
#define SPIKE 5

/* peak detection code (V1 or V2) */
#define V3

/* area^2 average to call it a one. V1 only*/
#define THRESH 5000

#ifdef VERSION1
#define SYNC2LEN 39     /* length if second sync signal -1 */
#define FRAMESKIP 400   /* number of sample between words, approx */
#endif

#ifdef VERSION2
#define SYNC2LEN 49
#define FRAMESKIP 20
#endif

/* This, in the near future, will convert ulaw into linaer.
*/
int getsamp(FILE *in)
{
	int a;
	a=fgetc(in);
	if (a==EOF)
		return -1;
	return 255-a;
}

/* put the curve against the x axis, then calculate the area
** under it.  If it is above the threshold, call it a 1
** note I'm adding the square, this will make tall narrow spikes "bigger"
** than short wide non-spikes
*/
#ifdef V1
int ispeak(unsigned char data[],int len)
{
	int i,min,d;
	long int t;

	min=data[0];
	for(i=1;i<len;i++)
		if (data[i]<min)
			min=data[i];
	t=0;
	for(i=0;i<len;i++)
	{
		d=abs(data[i]-min);
		t+=d*d;
	}

	return t>THRESH;
}
#endif
#ifdef V2
int ispeak(unsigned char data[],int len)
{
	int i,min,d;
	long int t;

	min=data[0];
	for(i=1;i<len;i++)
		if (data[i]<min)
			min=data[i];
	t=0;
	for(i=1;i<len;i++)
	{
		d=abs((data[i]*data[i])-(data[i-1]*data[i-1]));
		t+=d;
	}
	t=(int)sqrt((double)t);
#ifdef SHOWBITS
	printf("     %d\n",t);
#endif
	return t>75;
}
#endif

#ifdef V3
int peakarea(unsigned char data[],int len)
{
	int i,min,avg,max,d,a,b;
	long int t;

	float slope;

	slope=(float)(data[len-1]-data[0])/(float)len;

	avg=data[0];
	min=data[0];
	max=data[0];
	for(i=1;i<len;i++)
	{
		d=data[i]-((int)(slope*i)+data[0]);
		avg+=d;
		if (d<min)
			min=d;
		if (d>max)
			max=d;
	}
	avg=avg/len;

	t=0;
	for(i=1;i<len;i++)
	{
		a=abs(data[i]-((int)(slope*i)+data[0]));
		b=abs(data[i-1]-((int)(slope*i)+data[0]));
		d=abs(a-b);
		t+=d*d;
	}


	t=(int)pow((double)t*100.0,1.0/2.0);
#ifdef SHOWBITS
	printf("%3d %3d %3d %3d %3d   %d\n",data[0],min,avg,max,data[len-1],t);
#endif
	return t;
}
#endif


void waitforsync(FILE *in)
{
	int a,b;

	a=getsamp(in);
	b=getsamp(in);
	while((abs(b-a)<SPIKE) && (a!=-1) && (b!=-1))
	{
		a=b;
		b=getsamp(in);
	}
}

/* UART, in software.  
*/
int getword(FILE *in)
{
	unsigned char buff[1024];
	int data,i,j,k,t,c;
	int peak[8];
	int min,max,avg;

	static int lastavg=120;

	waitforsync(in);             /* wait for sync */
	for(c=0;c<(CLOCK/2);c++)
		t=getsamp(in); /* forward 0.5 bits, to center rest of peaks */

	for(i=0;i<8;i++)
	{
		for(c=0;c<CLOCK;c++)
			buff[c]=getsamp(in);
		peak[i]=peakarea(buff,CLOCK);
	}
	min=max=avg=peak[0];
	for(i=1;i<8;i++)
	{
		if (peak[i]>max)
			max=peak[i];
		if (peak[i]<min)
			min=peak[i];
		avg+=peak[i];
	}
	avg=avg/8;

	if (((max>lastavg) && (min>lastavg)) || ((max<lastavg) && (min<lastavg)))
		avg=lastavg;  /* its a 0xFF or 0x00, use old cutof */
	else
		avg=(int)((float)(max-min)*0.30)+min;
	lastavg=avg;

	data=0;
	for(i=0;i<8;i++)
	{
		data>>=1;
		if (peak[i]<avg)
			data|=0x80;
	}
	for(c=0;c<FRAMESKIP;c++)
		t=getsamp(in);   /* approx skip to next frame */
#ifdef SHOWBYTES
	printf("%ld %d  %x\n",ftell(in),avg,data);
#endif
	return data;
}

int getpacket(unsigned char *buff,FILE *in)
{
	int i,len,data,crc;
	buff[0]=getword(in);
	len=buff[0];

	for(i=1;i<len;i++)
		buff[i]=getword(in);
#ifdef VERSION2
	if (len&1)
		i=getword(in); /* In version 2, packets are padded to even length */
#endif
	crc=docrc(buff);
	if (((int)buff[len-2]!=((crc>>8)&0xFF)) || ((int)(buff[len-1])!=(crc&0xFF)))
		printf("CRC Error! (0x%4x %x %x)\n",crc,(int)buff[len-2],(int)buff[len-1]);

	return len;
}

void printstring(unsigned char buff[],int beg, int len)
{
	int d,o,c;
	d=0;
	o=0;
	c=0;
	do
	{
		if (o<6)
		{
			d|=buff[c+beg]<<o;
			o+=8;
			c++;
		}
		if ((d&0x3f) == 0x3f)
			break;
		printf("%c",(d&0x3F)>9?((d&0x3F)<36?((d&0x3F)+'A'-10):(d&0x3F)<52?((d&0x3F)+' '-36):((d&0x3F)+' '-26)):((d&0x3F)+'0'));

		d>>=6;
		o-=6;
	}
	while (c<len);
}

int printapp(unsigned char buff[],int beg)
{
	printf("Appointment:\n");
	printf("Date: %d/%d\n",buff[beg+1],buff[beg+2]);
	printf("Time: %d:%d\n",((int)buff[beg+3]>>2)&0x1F,(((int)buff[beg+3]&1)?15:0)+(((int)buff[beg+3]&2)?30:0));
	printf("Message: ");
	printstring(buff,beg+4,(int)buff[beg]-4);
	printf("\n\n");

	return beg+(int)buff[beg];
}

int printani(unsigned char buff[],int beg)
{
	printf("Aniversary:\n");
	printf("Date: %d/%d\n",buff[beg+1],buff[beg+2]);
	printf("Message: ");
	printstring(buff,beg+3,buff[beg]-3);
	printf("\n\n");
	
	return beg+buff[beg];
}

int printtodo(unsigned char buff[],int beg)
{
	printf("ToDo:\n");
	printf("Priority: %d\n",buff[beg+1]);
	printf("Message: ");
	printstring(buff,beg+2,buff[beg]-2);
	printf("\n\n");

	return beg+buff[beg];
}

int printphone(unsigned char buff[],int beg)
{
	int i;
	int d;
	printf("Phone number: (len = %d)\n", buff[beg]);
	printstring(buff,beg+7,buff[beg]-7);
	printf("\n");
	for(i=0;i<12;i++) {
		d = (i&1)?(buff[(i>>1)+beg+1]>>4):(buff[(i>>1)+beg+1]&0xf);
		if (d >= 0xa)
			printf("%c", "CFHPW "[d - 0xa]);
		else
			printf("%d",d);
	}
	printf("\n");

	return beg+buff[beg];
}

#ifdef DEBUG
main()
{
	int data,len;
	unsigned char pack[1024];
	int i,a,b;

	a=getword(stdin);
	b=getword(stdin);
	while((a!=0x55) || (b!=0xAA))
	{
		a=b;
		b=getword(stdin);
	}

	printf("sync1\n");
	for(i=0;i<SYNC2LEN;i++)
		if ((data=getword(stdin))!=0xAA)
		{
			fprintf(stderr,"Sync2: less than %d 0xAA's\n",SYNC2LEN+1);
			exit(1);
		}
	printf("sync2\n");

	while(!feof(stdin))
	{
		len=getpacket(pack,stdin);
		for(i=0;i<len;i++)
		{
			data=pack[i];
			printf("%3X   %c  %2d\n",data,(data&0x3F)>9?((data&0x3F)+'A'-10):((data&0x3F)+'0'),data&0x1F);
		}
		printf("packet boundry\n");
	}
}

#else
main()
{
	int data;
	int i,j,a,b;
	unsigned char pack[1024],buff[4096];
	unsigned char wapp[2048],mel[2048];
	int len,typ,cnt,sub;  /* length, type, count, sub type  */
	int napp,nani;    /* num appointments, num aniversaries */
	int ntodo,nph;        /* num todo's, num phone numbers  */
	int tot,alen,mlen;          /* total number of data bytes sofar */
	long int sum;

	a=getword(stdin);
	b=getword(stdin);
	while((a!=0x55) || (b!=0xAA))
	{
		a=b;
		b=getword(stdin);
	}

	printf("sync1\n");
	for(i=0;i<SYNC2LEN;i++)
		if ((data=getword(stdin))!=0xAA)
		{
			fprintf(stderr,"Sync2: less than %d 0xAA's\n",SYNC2LEN+1);
			exit(1);
		}
	printf("sync2\n");

	tot=alen=mlen=0;

	while((typ!=0x21) &&(!feof(stdin)))
	{
		len=getpacket(pack,stdin);
		typ=pack[1];
		switch (typ)
		{
			case 0x90:
				sub=pack[2];
				if (sub==1) {
					napp=pack[12];
					ntodo=pack[13];
					nph=pack[14];
					nani=pack[15];
					cnt=0;
				}
				break;
			case 0x91:
				switch (sub) {
				case 1:
					for(i=0;i<len-6;i++)
						buff[tot++]=pack[i+4];
					break;
				case 2:
					for(i=0;i<len-6;i++)
						wapp[alen++]=pack[i+4];
					break;
				case 3:
					for(i=0;i<len-6;i++)
						mel[mlen++]=pack[i+4];
					break;
				}
				break;
			case 0x61:
				for(i=0;i<len-5;i++)
					buff[tot++]=pack[i+3];
					if (tot < 40) {
						napp=buff[8];
						ntodo=buff[9];
						nph=buff[10];
						nani=buff[11];
					}
					cnt=14;
				break;
			case 0x20:
				printf("Protocol version %d,%d,%d\n",(int)pack[2],(int)pack[3],(int)pack[4]);
				break;
			case 0x32:
				printf("Set Time zone %d %d:%d:%d  %d/%d/%d \n",(int)pack[0+2],(int)pack[2+2],(int)pack[3+2],(int)pack[1+2],(int)pack[4+2],(int)pack[5+2],(int)pack[6+2]);
				break;
			case 0x50:
				printf("Set Alarm number %d  %d:%d silent: %d\n",(int)pack[0+2],(int)pack[1+2],(int)pack[2+2],(int)pack[13+2]);
				break;
		}

	}

	printf("%d apointments\n%d todo's\n%d Phone numbers\n%d aniversaries\n",napp,ntodo,nph,nani);
	for(i=0;i<napp;i++)
		cnt=printapp(buff,cnt);
	for(i=0;i<ntodo;i++)
		cnt=printtodo(buff,cnt);
	for(i=0;i<nph;i++)
		cnt=printphone(buff,cnt);
	for(i=0;i<nani;i++)
		cnt=printani(buff,cnt);
	printf("Wristapp -\n");
	for(i=0;i<alen;i+=16){
		for(j=i;j<i+16&&j<alen;j++)
			printf("%02x%c",wapp[j],(j==alen-1||j==i+15)?'\n':' ');
	}
	printf("Melody info -\n");
	for(i=0;i<mlen;i+=16){
		for(j=i;j<i+16&&j<mlen;j++)
			printf("%02x%c",mel[j],(j==mlen-1||j==i+15)?'\n':' ');
	}
}
#endif
