/* crc lookup table */
unsigned short int crc16_table[16]={
	0x0000, 0xCC01, 0xD801, 0x1400, 0xF001, 0x3C00, 0x2800, 0xE401,
	0xA001, 0x6C00, 0x7800, 0xB401, 0x5000, 0x9C01, 0x8801, 0x4400
};

unsigned short int
docrc(data)
unsigned char *data;
{
	int i;
	unsigned short int t;
	unsigned short int crc = 0;
	int l;

	l = data[0] - 2;

	for (i = 0; i < l; i++) {
		t = crc16_table[crc & 0xF];
		crc = (crc >> 4) & 0x0FFF;
		crc = crc ^ t ^ crc16_table[data[i] & 0xF];

		/* upper 4 bits */
		t = crc16_table[crc & 0xF];
		crc = (crc >> 4) & 0x0FFF;
		crc = crc ^ t ^ crc16_table[(data[i] >> 4) & 0xF];
	}

	return(crc);
}
