/* This software is Copyright 1996 by Karl R. Hakimian
 *
 *
 * Written by Karl R. Hakimian 10/3/96
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 *
 */

#include <stdio.h>
#include <fcntl.h>

#define toascii(d) ((d&0x3F)>9?((d&0x3F)<36?((d&0x3F)+'A'-10):(d&0x3F)<52?((d&0x3F)+' '-36):((d&0x3F)+' '-26)):((d&0x3F)+'0'))

main(argc, argv)
int argc;
char **argv;
{
	char *prog;
	int start = 0;
	int pstart = 0;
	int fd;
	unsigned char buf[1024];
	int n;
	int i, j;

	prog = argv[0];

	while (argc > 1 && *argv[1] == '-') {

		switch (argv[1][1]) {
		case 'o':
			start = atoi(&argv[1][2]);
			break;
		case 's':
			pstart = atoi(&argv[1][2]);
			break;
		default:
			fprintf(stderr, "Unknown option %s\n", argv[1]);
			exit(-1);
		}

		argc--;
		argv++;
	}

	if (argc < 2) {
		fprintf(stderr, "Usage: %s file [file ...]\n", prog);
		exit(-1);
	}

	for (;argc >= 2; argc--, argv++) {

		if ((fd = open(argv[1], O_RDONLY)) == -1) {
			fprintf(stderr, "Could not open %s for reading.\n", argv[1]);
			continue;
		}

		printf("Dump of %s:\n", argv[1]);

		while ((n = read(fd, buf, 1024)) > 0) {

			for (i = start; i < n; i += 16) {
				printf("%04x:", i - start + pstart);

				for (j = 0; j < 16; j++) {

					if (i + j >= n)
						break;

					printf(" %02x", buf[i + j]);
				}

				printf(" - ");

				for (j = 0; j < 16; j++) {

					if (i + j >= n)
						break;

					printf("%c", toascii(buf[i + j]));
				}

				printf("\n");
			}

		}

		if (n)
			printf("n = %d\n", n);

		printf("\n");
		close(fd);
	}

	exit(0);
}
