/* Copyright 1996 Tommy Johnson
**
** Permission is hereby granted to copy, reproduce, redistribute or otherwise
** use this software as long as: there is no monetary profit gained
** specifically from the use or reproduction of this software, it is not
** sold, rented, traded or otherwise marketed, and this copyright notice is
** included prominently in any copy made.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
** SOFTWARE IS AT THE USER'S OWN RISK.
*/

#include<stdio.h>
#include"table.h"

int disassem(unsigned char *prog, int len)
{
	int pc=0,d,r;
	int ci,valid;

	while(pc<len)
	{
		valid=0;
		for(ci=0;ci<256;ci++)
			if (table[ci].opcode==prog[pc])
			{
				printf("%4x %10s ",pc,table[ci].name);
				valid=1;
				break;
			}
		if (!valid)
			printf("%4x  Invalid opcode %2x\n",pc,((int)(prog[pc]))&0xff);
		pc++;
		switch (table[ci].format)
		{
			case DIR2:
				d=prog[pc++];
				r=prog[pc++];
				if (r&0x80)
					r=-((~r)&0x7F);
				printf("%02x %02x\n",d,pc+r);
				break;
			case DIR:
				printf("%04x\n",prog[pc++]);
				break;
			case EXT:
				d=prog[pc++]<<8;
				d|=prog[pc++];
				printf("%04x\n",d);
				break;
			case REL:
				r=prog[pc++];
				if (r&0x80)
					r=-((~r)&0x7F)-1;
				printf("%02x\n",pc+r);
				break;
			case INH:
				printf("\n");
				break;
			case IX:
				printf(",X\n");
				break;
			case IX1:
				printf("%02x,X\n",prog[pc++]);
				break;
			case IX2:
				d=prog[pc++]<<8;
				d|=prog[pc++];
				printf("%04x,X\n",d);
				break;
			case IMM:
				printf("#%02x\n",prog[pc++]);
				break;
		}
	}
}

main(int argc,char *argv[])
{
	unsigned char buff[1024*10];
	FILE *fil;
	int len;

	if (argc!=2)
	{
		printf("usage: dis [filename]\n");
		exit(1);
	}

	if (!(fil=fopen(argv[1],"r")))
	{
		perror("dis: ");
		exit(1);
	}
	len=fread(buff,1,sizeof(buff),fil);
	close(fil);
	disassem(buff,len);
}
