/* Copyright 1996 Tommy Johnson
**
** Permission is hereby granted to copy, reproduce, redistribute or otherwise
** use this software as long as: there is no monetary profit gained
** specifically from the use or reproduction of this software, it is not
** sold, rented, traded or otherwise marketed, and this copyright notice is
** included prominently in any copy made.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
** SOFTWARE IS AT THE USER'S OWN RISK.
*/

/* Addressing modes:
*/
#define DIR2 1     /* Direct/REL, used only for BRSET and BRCLR */
#define DIR 2      /* Direct, 1 byte address (high byte is 0x00) */
#define EXT 3      /* Extended, 2 byte address */
#define REL 4      /* Relative, 1 byte signed offset (branches only) */
#define INH 5      /* Inherent, no arg */
#define IX  6      /* Indexed, no offset */
#define IX1 7      /* Indexed, 1 byte unsigned offset */
#define IX2 8      /* Indexed, 2 byte unsigned offset */
#define IMM 9      /* Immediate, 1 byte arg */
#define DIR3 10    /* Direct used for BSET and BCLR */

/* unknown addressing modes, with 1 arg, 2 args, 3 args 
   (mode will be determined later from the opcode)
*/
#define UNKNOWN1  20
#define UNKNOWN2  21
#define UNKNOWN3  22

#define NUMINST 216

struct inst 
{
	int opcode;
	int mask;
	int format;
	char *name;
};
