/* Copyright 1996 Tommy Johnson
**
** Permission is hereby granted to copy, reproduce, redistribute or otherwise
** use this software as long as: there is no monetary profit gained
** specifically from the use or reproduction of this software, it is not
** sold, rented, traded or otherwise marketed, and this copyright notice is
** included prominently in any copy made.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
** SOFTWARE IS AT THE USER'S OWN RISK.
*/

#include<stdio.h>
#include<strings.h>
#include"asm.h"
#include"symboltab.h"

static int nsym;
static struct ident symboltab[MAXSYM];

void initsymbol(void)
{
	nsym=0;
}

int getsymbol(char *id)
{
	int i;

	for(i=0;i<nsym;i++)
		if (!strcmp(symboltab[i].name,id))
		{
			if (pass==2)
			{
				if (!symboltab[i].defined)
				{
					fprintf(stderr,"line %d: symbol %s used but not defined.",lineno,id);
					return 0;
				}
				else
					return symboltab[i].value;
			}
			else
				return 0;

		}
	return 0;
}

int defsymbol(char *id)
{
	int i,f=-1;

	if (pass==2)
		return 1;

	for(i=0;i<nsym;i++)
		if (!strcmp(symboltab[i].name,id))
			f=i;
	if (f<0)
	{
		f=nsym++;
		symboltab[f].name=strdup(id);
	}
	if (symboltab[f].defined)
		fprintf(stderr,"line %d: symbol %s redefined.\n",lineno,id);
	symboltab[f].defined=1;
	symboltab[f].value=pc;
}

void dumpsymboltable(FILE *fil)
{
	int i;

	for(i=0;i<nsym;i++)
		fprintf(fil,"%04x %c  %s\n",symboltab[i].value,symboltab[i].defined?' ':'*',symboltab[i].name);
}

