/* Copyright 1997,1998,2000 Tommy Johnson  All Rights Reserved
**
** Permission is hereby granted to copy, reproduce, redistribute or otherwise
** use this software as long as: there is no monetary profit gained
** specifically from the use or reproduction of this software, it is not
** sold, rented, traded or otherwise marketed, and this copyright notice is
** included prominently in any copy made.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
** SOFTWARE IS AT THE USER'S OWN RISK.
*/

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<ctype.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/fcntl.h>
#include <sys/signal.h>
#include <machine/ioctl_meteor.h>
#include<X11/Xlib.h>
#include<X11/StringDefs.h>
#include<X11/Intrinsic.h>
#include<X11/Shell.h>
#include<X11/Xaw/Label.h>
#include<X11/Xaw/Command.h>
#include<X11/Xaw/Toggle.h>
#include<X11/Xaw/Form.h>
#include<X11/Xaw/Scrollbar.h>

#ifdef SH_MEM
/* shared memory code based on mpeg2play code, which is based on the 
** mpegplay player from berkeley
*/
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>   
static XShmSegmentInfo shminfo1;
static int CompletionType=-1;
#endif

int doshm=0;

static char *fallback[] = { 
	"video.title: Video",
	"video.main.quit.label: Quit",
	"video.main.grab.label: Grab",
	"video.main.grabcon.label: Continuous Grab",
	"video.main.fpslabel.label: FPS:",
	"video.main.fpslabel.borderWidth: 0",
	"video.main.fps.label: 000",
	(char*)NULL
	};

typedef struct slider_struct {
	int command;
	int file;
} slider;

void scrolljump(Widget w, slider *com, float *pos)
{
	unsigned char g;
	g=(char)(255.0*(*pos));
	if (ioctl(com->file, com->command, &g) < 0)
		perror("scrolljump: ioctl failed ");
}

int get_header(FILE *fil, int *width, int *height);
void writeframe(unsigned char *data,FILE *fil);

XtAppContext app;
Widget shell,form,quitw,grabw,grabcon,fpsw,fpslabelw;
Widget bri,con,gain;
int video;     /* made global if you wish to stop capture in signal handler */
int frames=0;
caddr_t data_frames;
extern int errno;
char *buf;
FILE *videofile;
int grabbing=0;
FILE *grabfil;
int length;   /* length limit, stop reading video file after this many frames (or negative for read to EOF)  */

int source;     /* video source  (live or file)  */
#define VIDEO 1
#define FROMFILE 2
int size;

int w,h;         /* image dimentions  */
unsigned int *imagedat;   /* X image data buffer, pointed to by ximage */
Widget image;

void (*frametodisp)();

void frame32to16 (unsigned char *imagedat,unsigned char *rawimagedat)
{
	int x,p=0;
	for(x=0;x<(w*h*4);x+=4)
	{
		imagedat[p]=((rawimagedat[x]&0xF8)>>3) | ((rawimagedat[x+1]&0x1C)<<3);
		imagedat[p+1]=((rawimagedat[x+2]&0xF8)) | (((rawimagedat[x+1])&0xE0)>>5);
		p+=2;
	}
}

void frame32to32 (unsigned int *imagedat,unsigned int *rawimagedat)
{
	int x,p=0;
	for(x=0;x<(w*h);x++)
	{
		imagedat[p]=rawimagedat[p];
		p++;
	}
}

void frame24to16 (unsigned char *imagedat,unsigned char *rawimagedat)
{
	int x,p=0;
	for(x=0;x<(w*h*3);x+=3)
	{
		imagedat[p]=((rawimagedat[x+2]&0xF8)>>3) | ((rawimagedat[x+1]&0x1C)<<3);
		imagedat[p+1]=((rawimagedat[x]&0xF8)) | (((rawimagedat[x+1])&0xE0)>>5);
		p+=2;
	}
}

void frame16to16 (unsigned char *buff2,unsigned char *yuv_data)
{
	int i;

	for(i=0;i<w*h*2;i+=2)
        {
                buff2[i]=(yuv_data[i]&0x1F) | ((yuv_data[i]&0xE0)<<1);
                buff2[i+1]=((yuv_data[i+1]<<1)&0xFE) | ((yuv_data[i]>>7));
        }
}

void frame16to32 (unsigned int *buff2,unsigned short int *yuv_data)
{
	int i;

	for(i=0;i<w*h;i++)
	{
		buff2[i]=((yuv_data[i]&0x7800)<<9) | ((yuv_data[i]&0x03E0) << 6) | ((yuv_data[i]&0x001F)<<3);
	}
}

void frame24to32 (unsigned int *buff2,unsigned char *yuv_data)
{
	int i,j;

	j=0;
	for(i=0;i<w*h;i++)
	{
		buff2[i]=yuv_data[j+1]<<8 | yuv_data[j+2] | yuv_data[j] << 16 ;
		j+=3;
	}
}

void frame16to24 (unsigned char *buff2,unsigned char *yuv_data)
{
	int i,j;

	j=0;
	for(i=0;i<(w*h*3);i+=3)
	{
		buff2[i]=yuv_data[j]&0x1F;
		buff2[i+1]=0;
		buff2[i+2]=0;
		j+=2;
	}
}

int initmeteor(int width,int height,int input, int _gain, int _bri, int _con)
{
	int frames, depth;
	int c;
	unsigned char gain,bri,con;
	struct meteor_geomet geo;

	gain=_gain;
	bri=_bri;
	con=_con;

	if ((video = open("/dev/meteor0", O_RDONLY)) < 0) {
		printf("open failed");
		return 1;
	}

	geo.columns = width;
	geo.rows = height;
	frames = geo.frames = 1;
#ifdef BPP16
	depth = 2;		   /* 2 bytes per pixel for RGB*/
	geo.oformat = METEOR_GEO_RGB16;
#else
	depth = 4;		   /* 4 bytes per pixel for RGBA*/
	geo.oformat = METEOR_GEO_RGB24;   // | METEOR_GEO_EVEN_ONLY;
#endif
	if (ioctl(video, METEORSETGEO, &geo) < 0) {
		printf("METEORSETGEO failed %d\n", errno);
		return 2;
	}

	c = METEOR_FMT_NTSC;

	if (ioctl(video, METEORSFMT, &c) < 0) {
		printf("ioctl failed: %d\n", errno);
		return 2;
	}

	if (ioctl(video, METEORSINPUT, &input) < 0) {
		printf("ioctl failed: %d", errno);
		return 2;
	}
#if 0
	if (ioctl(video, METEORSCHCV, &gain) < 0) {
		fprintf(stderr,"METEORSCHCV ioctl failed: %d", errno);
		return 2;
	}
#endif
	if (ioctl(video, METEORSBRIG, &bri) < 0) {
		fprintf(stderr,"METEORSBRIG ioctl failed: %d", errno);
		return 2;
	}
	if (ioctl(video, METEORSCONT, &con) < 0) {
		fprintf(stderr,"METEORSCONT ioctl failed: %d", errno);
		return 2;
	} 

	size = width*height*depth;
	    /* add one page after data for meteor_mem */
	data_frames = mmap((caddr_t)0, size, PROT_READ, 0, video, (off_t)0);

	if (data_frames == (caddr_t) -1)
		return (1);

	return 0;
}

/* begin ppm stuff here:   */

typedef struct { unsigned char r,g,b;} pixel;

int get_header(FILE *fil, int *width, int *height)
{
	int a,comment,max;
	char temp[2];

	fread(temp,1,2,fil);
	if ((temp[0]!='P') || (temp[1]!='6'))
		return -1;

	comment=0;
	while (!comment)
	{
		comment=1;
		while (isspace(a=fgetc(fil)))
			;
		if (a=='#')
		{
			while((a=fgetc(fil))!='\n')
				;
			comment=0;
		}
	ungetc(a,fil);
	}

	fscanf(fil,"%d",width);
	comment=0;
	while (!comment)
	{
		comment=1;
		while (isspace(a=fgetc(fil)))
			;
		if (a=='#')
		{
			while((a=fgetc(fil))!='\n')
				;
			comment=0;
		}
	ungetc(a,fil);
	}

	fscanf(fil,"%d",height);
	comment=0;
	while (!comment)
	{
		comment=1;
		while (isspace(a=fgetc(fil)))
			;
		if (a=='#')
		{
			while((a=fgetc(fil))!='\n')
				;
			comment=0;
		}
	ungetc(a,fil);
	}
	comment=0;
	while (!comment)
	{
		comment=1;
		while (isspace(a=fgetc(fil)))
			;
		if (a=='#')
		{
			while((a=fgetc(fil))!='\n')
				;
			comment=0;
		}
	ungetc(a,fil);
	}
	fscanf(fil,"%d",&max);
	while((a=fgetc(fil))!='\n')
		;
	return 0;
}

int get_row(FILE *fil, int width, pixel *data)
{
	return fread(data,sizeof(pixel),width,fil);
}

int put_row(int fil, int width, pixel *data)
{
	return write(fil,data,width*sizeof(pixel));
}

#define MAX(a,b)	(((a)>(b))?(a):(b))
#define MIN(a,b)	(((a)<(b))?(a):(b))


static void hsv_rgb (double h, double s, double v,
			  double *r, double *g, double *b);
static void rgb_hsv (double r, double g, double b,
			  double *h, double *s, double *v);

/*  HSV_RGB  --  Convert HSV colour specification to RGB  intensities.
		 Hue is specified as a	real  value  from  0  to  360,
		 Saturation  and  Intensity as reals from 0 to 1.  The
		 RGB components are returned as reals from 0 to 1. */

static void hsv_rgb(h, s, v, r, g, b)
  double h, s, v;
  double *r, *g, *b;
{
    int i;
    double f, p, q, t;

    if (s == 0) {
	*r = *g = *b = v;
    } else {
	if (h == 360.0) {
	    h = 0;
	}
	h /= 60.0;

	i = h;
	f = h - i;
	p = v * (1.0 - s);
	q = v * (1.0 - (s * f));
	t = v * (1.0 - (s * (1.0 - f)));
	switch (i) {

	    case 0:
		*r = v;
		*g = t;
		*b = p;
		break;

	    case 1:
		*r = q;
		*g = v;
		*b = p;
		break;

	    case 2:
		*r = p;
		*g = v;
		*b = t;
		break;

	    case 3:
		*r = p;
		*g = q;
		*b = v;
		break;

	    case 4:
		*r = t;
		*g = p;
		*b = v;
		break;

	    case 5:
		*r = v;
		*g = p;
		*b = q;
		break;
	 }
    }
}

/*  RGB_HSV  --  Map R, G, B intensities in the range from 0 to 1 into
		 Hue, Saturation,  and	Value:	Hue  from  0  to  360,
		 Saturation  from  0  to  1,  and  Value  from 0 to 1.
                 Special case: if Saturation is 0 (it's a  grey  scale
		 tone), Hue is undefined and is returned as -1.

		 This follows Foley & van Dam, section 17.4.4. */

static void rgb_hsv(r, g, b, h, s, v)
  double r, g, b;
  double *h, *s, *v;
{
    double imax = MAX(r, MAX(g, b)),
	   imin = MIN(r, MIN(g, b)),
	   rc, gc, bc;

    *v = imax;
    if (imax != 0) {
	*s = (imax - imin) / imax;
    } else {
	*s = 0;
    }

    if (*s == 0) {
	*h = -1;
    } else {
	rc = (imax - r) / (imax - imin);
	gc = (imax - g) / (imax - imin);
	bc = (imax - b) / (imax - imin);
	if (r == imax) {
	    *h = bc - gc;
	} else if (g == imax) {
	    *h = 2.0 + rc - bc;
	} else {
	    *h = 4.0 + gc - rc;
	}
	*h *= 60.0;
	if (*h < 0.0) {
	    *h += 360.0;
	}
    }
}

XImage *ximage;
GC gc;
Display *display;

static void quit()
{
	if (gc)
		XFreeGC(display,gc);
#ifdef SH_MEM
	if (doshm)
	{
		XShmDetach(display,&shminfo1);
		XDestroyImage(ximage);
		shmdt(shminfo1.shmaddr);
		shmctl(shminfo1.shmid,IPC_RMID,0);
	}
	else
#endif
	XDestroyImage(ximage);

	exit(0);
}

static int redraw_event(Widget dumw, Widget wig, XExposeEvent *ev)
{
	
	static gcexist=0;
	static int framecount=0;

	int i;
	if (!gcexist)
	{
		gc=XCreateGC(display,XtWindow(image),0,0);
		gcexist=1;
	}

	switch (source)
	{
		case VIDEO:

			i=METEOR_CAP_SINGLE;
			ioctl(video,METEORCAPTUR,&i);
			(frametodisp)(imagedat,data_frames);
			if (grabbing)
				writeframe(data_frames,grabfil);
		break;
		case FROMFILE:
			XtAppAddTimeOut(app,1000/4,redraw_event,image);
			if ((length<0) ||  (framecount<length))
			{
				fread(data_frames,1,size,videofile);
				framecount++;
			}
/*
			16 BPP display:
			frame32to16(imagedat,data_frames);
*/
			frame24to32(imagedat,data_frames);
		break;
	}

#ifdef SH_MEM
	if (doshm)
	{
		XShmPutImage(display,XtWindow(image),gc,ximage,0,0,0,0,w,h,True);
	}
	else
#endif
		XPutImage(display,XtWindow(image),gc,ximage,0,0,0,0,w,h); 

	frames++;
	return 0;
}

static void updatefps()
{
	char buff[1024];

	sprintf(buff,"%02d",frames);

	XtVaSetValues(fpsw,XtNlabel,buff,NULL);
	XtAppAddTimeOut(app,1000,updatefps,NULL);

	frames=0;
}

static void grabframevideo()
{
	static int count=0;
	char name[1024];
	FILE *fil;

	sprintf(name,"frame%04d.ppm",count++);
	fprintf(stderr,"%s\n",name);
	fil=fopen(name,"w");
	if (!fil)
		return;

	fprintf(fil,"P6\n%d %d\n255\n",w,h);
	writeframe(data_frames,fil);
	fclose(fil);
}

static void grabframefile()
{
	static int count=0;
	char name[1024];
	FILE *fil;
	static char *buff=NULL;   /* preserved between calls */

	if (!buff)
		buff=malloc(w*h*3);
	if (!buff)
		return;

	sprintf(name,"frame%04d.ppm",count++);
	fprintf(stderr,"%s\n",name);
	fil=fopen(name,"w");
	if (!fil)
		return;

	fprintf(fil,"P6\n%d %d\n255\n",w,h);
	fread(data_frames,1,size,videofile);
	fwrite(data_frames,1,size,fil);

	fclose(fil);
}

void writeframe(unsigned char *data,FILE *fil)
{
	int i,j;
	static char *buff=NULL;   /* preserved between calls */

	if (!buff)
		buff=malloc(w*h*3);
	if (!buff)
		return;
	j=0;
#ifdef BPP16
	for(i=0;i<(w*h*2);i+=2)
	{
		buff[j++]=(data[i+1]&0x78) << 1;
		buff[j++]=(data[i+1]&0x03) << 6 | (data[i]&0xE0)>>2;
		buff[j++]=(data[i]&0x1F) << 3; 
	}
#else
	for (i=0;i<(w*h*4);i+=4)
	{
		buff[j++]=data[i+2];
		buff[j++]=data[i+1];
		buff[j++]=data[i];
	}
#endif
	fwrite(buff,1,w*h*3,fil);
}

static void grabcont(Widget wig)
{
	short s;
	static int c;
	char name[16];

	XtVaGetValues(wig,XtNstate,&s,NULL);
	if (s)
	{
		if (grabfil)
			fclose(grabfil);
		sprintf(name,"movie%04d.ppm",c++);
		fprintf(stderr,"%s\n",name);
		grabfil=fopen(name,"w");
		if (!grabfil)
			return;
		fprintf(grabfil,"P6\n%d %d\n255\n",w,h);
		grabbing=1;
	}
	else
	{
		if (grabfil)
			fclose(grabfil);
		grabfil=NULL;
		grabbing=0;
	}
}

int main(int argc, char *argv[])
{
	slider *slid;
	extern char *optarg;
	char *filename=NULL;
	int c,i,dispdepth,imagesize;
	int input=METEOR_INPUT_DEV0;
	int start;

	w=320;
	h=240;
	source=VIDEO;
	start=0;
	length=-1;
	while ((c=getopt(argc,argv,"w:h:f:i:s:l:"))!=-1)
	switch (c)
	{
		case 's':
			sscanf(optarg,"%d",&start);
			break;
		case 'l':
			sscanf(optarg,"%d",&length);
			break;
		case 'w':
			sscanf(optarg,"%d",&w);
			break;
		case 'h':
			sscanf(optarg,"%d",&h);
			break;
		case 'f':
			source=FROMFILE;
			filename=strdup(optarg);
			break;
		case 'i':
			sscanf(optarg,"%d",&i);
			switch (i)
			{
				case 0:
					input=METEOR_INPUT_DEV0; break;
				case 1:
					input=METEOR_INPUT_DEV1; break;
				case 2:
					input=METEOR_INPUT_DEV2; break;
				case 3:
					input=METEOR_INPUT_DEV3; break;
				case 4:
					input=METEOR_INPUT_DEV_RGB; break;
				case 5:
					input=METEOR_INPUT_DEV_SVIDEO; break;
				default:
					input=METEOR_INPUT_DEV0; break;
			}
			break;
	}

	if ((!filename) && (source==FROMFILE))
		exit(1);

	switch(source)
	{
		case FROMFILE:
			videofile=fopen(filename,"r");
			get_header(videofile,&w,&h);
			size=w*h*3;
			fseek(videofile,size*start,SEEK_CUR);
			data_frames=malloc(size);

		break;
		case VIDEO:
			if (initmeteor(w,h,input,250,127,127))
				exit(1);
		break;
	}


        shell=XtVaOpenApplication(&app,"video",0,0,&argc,argv,fallback,topLevelShellWidgetClass,(String)0);
	form=XtVaCreateManagedWidget("main",formWidgetClass,shell,NULL);
	quitw=XtVaCreateManagedWidget("quit",commandWidgetClass,form,NULL);
	grabw=XtVaCreateManagedWidget("grab",commandWidgetClass,form,XtNfromHoriz,quitw,NULL);
	grabcon=XtVaCreateManagedWidget("grabcon",toggleWidgetClass,form,XtNfromHoriz,grabw,NULL);
	fpslabelw=XtVaCreateManagedWidget("fpslabel",labelWidgetClass,form,XtNfromHoriz,grabcon,NULL);
	fpsw=XtVaCreateManagedWidget("fps",labelWidgetClass,form,XtNfromHoriz,fpslabelw,NULL);
	XtAddCallback(quitw,XtNcallback,(XtCallbackProc)quit,NULL);
	if (source==VIDEO)
	{
		XtAddCallback(grabw,XtNcallback,(XtCallbackProc)grabframevideo,NULL);
		XtAddCallback(grabcon,XtNcallback,(XtCallbackProc)grabcont,NULL);
	}
	if (source==FROMFILE)
	{
		XtAddCallback(grabw,XtNcallback,(XtCallbackProc)grabframefile,NULL);
	}
	image=XtVaCreateManagedWidget("image",coreWidgetClass,form,XtNwidth,w,XtNheight,h,XtNfromVert,quitw,NULL);
	XtAddEventHandler(image,ExposureMask|StructureNotifyMask,FALSE,(XtEventHandler)redraw_event,NULL);

	bri=XtVaCreateManagedWidget("brightness",scrollbarWidgetClass,form,XtNfromVert,image,XtNorientation,XtorientHorizontal,XtNlength,w,NULL);
	con=XtVaCreateManagedWidget("contrast",scrollbarWidgetClass,form,XtNfromVert,bri,XtNorientation,XtorientHorizontal,XtNlength,w,NULL);
	gain=XtVaCreateManagedWidget("gain",scrollbarWidgetClass,form,XtNfromVert,con,XtNorientation,XtorientHorizontal,XtNlength,w,NULL);
	slid=malloc(sizeof(slider));
	slid->file=video;
	slid->command=METEORSBRIG;
	if (source==VIDEO)
		XtAddCallback(bri,XtNjumpProc,scrolljump,slid);
	slid=malloc(sizeof(slider));
	slid->file=video;
	slid->command=METEORSCONT;
	if (source==VIDEO)
		XtAddCallback(con,XtNjumpProc,scrolljump,slid);
	slid=malloc(sizeof(slider));
	slid->file=video;
	slid->command=METEORSCHCV;
	if (source==VIDEO)
		XtAddCallback(gain,XtNjumpProc,scrolljump,slid);

	updatefps();

	display=XtDisplay(image);

	dispdepth=DefaultDepthOfScreen(XtScreen(image));
	fprintf(stderr,"display depth %d\n",dispdepth);
	switch (dispdepth)
	{
#ifdef BPP16
		case 16: frametodisp=frame16to16;  break;
		case 24: frametodisp=frame16to32;  break;
#else
		case 16: frametodisp=frame32to16;  break;
		case 24: frametodisp=frame32to32;  break;
#endif
		default: fprintf(stderr,"I can't do this depth\n");
	}
	imagesize=(w*h*4);   /* FIXME, should be dispdepth */

#ifdef SH_MEM
	doshm=0;
/*
	if (XShmQueryExtension(display))
		doshm=1;
*/
	if (doshm)
	{
		XSync(display,True);
		ximage=XShmCreateImage(display,None,dispdepth,ZPixmap,0,&shminfo1,w,h);
		if (!ximage)
			{doshm=0; goto shmerror;}

		shminfo1.shmid=shmget(IPC_PRIVATE,imagesize,IPC_CREAT|0777);
		if (shminfo1.shmid<0)
			{doshm=0; XDestroyImage(ximage); goto shmerror;}
		shminfo1.shmaddr=(char*)shmat(shminfo1.shmid,0,0);
		if (shminfo1.shmaddr==((char*)-1))
			{doshm=0; XDestroyImage(ximage); goto shmerror;}
		ximage->data=shminfo1.shmaddr;
		shminfo1.readOnly=False;
		XShmAttach(display,&shminfo1);
		imagedat=shminfo1.shmaddr;
		XSync(display,False);
		CompletionType = XShmGetEventBase(display) + ShmCompletion;
		printf("attempting to share memory\n");
shmerror:
	}

#endif

	if (!doshm)   /* normal xlib, no shared memory */
	{
		imagedat=malloc(imagesize);
		ximage=XCreateImage(display,None,dispdepth,ZPixmap,0,imagedat,w,h,8,0);
	}

	switch (source)
	{
		case VIDEO:
			XtAppAddWorkProc(app,redraw_event,image);
		break;
		case FROMFILE:
			// XtAppAddWorkProc(app,redraw_event,image);
			XtAppAddTimeOut(app,1000/8,redraw_event,image);
		break;
	}
	XtRealizeWidget(shell);
	XtAppMainLoop(app);
	return 0;
}
