#include<stdio.h>
#include<stdlib.h>
#include<fcntl.h>
#include<errno.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/fcntl.h>
#include <sys/signal.h>  
#include<machine/ioctl_meteor.h>
#include"meteorlib.h"

/* Copyright 1997,1998,2000 Tommy Johnson  All Rights Reserved
**
** Permission is hereby granted to copy, reproduce, redistribute or otherwise
** use this software as long as: there is no monetary profit gained
** specifically from the use or reproduction of this software, it is not
** sold, rented, traded or otherwise marketed, and this copyright notice is
** included prominently in any copy made.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
** SOFTWARE IS AT THE USER'S OWN RISK.
*/


meteorstruct *initmeteor(int width,int height,int depth,int format,int nframe,int field, int inp, int _gain, int _bri, int _con)
{
	int c;
	unsigned char gain,bri,con;
	struct meteor_geomet geo;
	meteorstruct *met;
	unsigned long input=inp;

	switch(inp)
	{
		case 0:
			input=METEOR_INPUT_DEV0; break;
		case 1:
			input=METEOR_INPUT_DEV1; break;
		case 2:
			input=METEOR_INPUT_DEV2; break;
		case 3:
			input=METEOR_INPUT_DEV3; break;
		case 4:
			input=METEOR_INPUT_DEV_RGB; break;
		case 5:
			input=METEOR_INPUT_DEV_SVIDEO; break;
		default:
			input=METEOR_INPUT_DEV0; break; 
	}

	met=malloc(sizeof(meteorstruct));
	if (!met)
		return NULL;

	gain=_gain;
	bri=_bri;
	con=_con;

	if ((met->fid = open("/dev/bktr0", O_RDWR)) < 0) {
		printf("open failed");
		return NULL;
	}

	geo.columns = width;
	geo.rows = height;
	geo.frames = nframe;
	if (format==METEORLIB_RGB)
		switch (depth)
		{
			case 2:
				geo.oformat = METEOR_GEO_RGB16;
			break;
			case 4:
				geo.oformat = METEOR_GEO_RGB24;
			break;
		}
	else
		switch (depth)
		{
			case 2:
				geo.oformat = METEOR_GEO_YUV_PACKED;
			break;
			case 4:
				geo.oformat = METEOR_GEO_RGB24;
			break;
		}

	if (field)
		geo.oformat|=METEOR_GEO_EVEN_ONLY;

	if (ioctl(met->fid, METEORSETGEO, &geo) < 0) {
		printf("METEORSETGEO failed %d\n", errno);
		return NULL;
	}

	if (ioctl(met->fid, METEORSINPUT, &input) < 0) {
		printf("ioctl failed: %d", errno);
		return NULL;
	}
#if 0
	c = METEOR_FMT_NTSC;
	if (ioctl(met->fid, METEORSFMT, &c) < 0) {
		printf("ioctl failed: %d\n", errno);
		return NULL;
	}
	if (ioctl(met->fid, METEORSCHCV, &gain) < 0) {
		fprintf(stderr,"METEORSCHCV ioctl failed: %d", errno);
		return NULL;
	}
#endif
	if (ioctl(met->fid, METEORSBRIG, &bri) < 0) {
		fprintf(stderr,"METEORSBRIG ioctl failed: %d", errno);
		return NULL;
	}
	if (ioctl(met->fid, METEORSCONT, &con) < 0) {
		fprintf(stderr,"METEORSCONT ioctl failed: %d", errno);
		return NULL;
	} 

	met->mode=0;   /* undefined */
	met->wid=width;
	met->heit=height;
	met->depth=depth;
	met->nframe=nframe;

	met->fsize=met->wid*met->heit*met->depth;
        met->bsize=((met->fsize*met->nframe+4095)/4096)*4096;
        met->buff= mmap((caddr_t)0,met->bsize + 4096, PROT_READ| PROT_WRITE, MAP_SHARED, met->fid, (off_t)0);   
	if (met->buff==((caddr_t)MAP_FAILED))
		return NULL;
	return met;
}

unsigned char *grabsingle(meteorstruct *met)
{
	int c;

	if (met->mode==0)
	{
		met->mode=METEOR_SINGLE;
	}
	if (met->mode==METEOR_SINGLE)
	{
		c=METEOR_CAP_SINGLE;
		if (ioctl(met->fid,METEORCAPTUR,&c)<0)
			perror("ioctl METEORCAPTUR:");
		return met->buff;
	}
	return NULL;
}

int meteorstatus(meteorstruct *met)
{
	unsigned short int stat;

	if (ioctl(met->fid,METEORSTATUS,&stat)!=0)
		return -1;
	else
		return stat;
}


void frame32to16 (unsigned char *imagedat,unsigned char *rawimagedat,int len)
{
	int x,p=0;
	for(x=0;x<(len*4);x+=4)
	{
		imagedat[p]=((rawimagedat[x]&0xF8)>>3) | ((rawimagedat[x+1]&0x1C)<<3);
		imagedat[p+1]=((rawimagedat[x+2]&0xF8)) | (((rawimagedat[x+1])&0xE0)>>5);
		p+=2;
	}
}

void frame32to24(unsigned char *output,unsigned int *input,int len)
{
	int i,p;
	p=0;
	for(i=0;i<len;i++)
	{
		output[p++]=input[i]>>16;
		output[p++]=input[i]>>8;
		output[p++]=input[i];
	}
}

void frame32to32 (unsigned int *imagedat,unsigned int *rawimagedat,int len)
{
	int x,p=0;
	for(x=0;x<len;x++)
	{
		imagedat[p]=rawimagedat[p];
		p++;
	}
}

void frame24to16 (unsigned char *imagedat,unsigned char *rawimagedat, int len)
{
	int x,p=0;
	for(x=0;x<(len*3);x+=3)
	{
		imagedat[p]=((rawimagedat[x+2]&0xF8)>>3) | ((rawimagedat[x+1]&0x1C)<<3);
		imagedat[p+1]=((rawimagedat[x]&0xF8)) | (((rawimagedat[x+1])&0xE0)>>5);
		p+=2;
	}
}

void frame16to16 (unsigned char *buff2,unsigned char *yuv_data,int len)
{
	int i;

	for(i=0;i<(len*2);i+=2)
        {
                buff2[i]=(yuv_data[i]&0x1F) | ((yuv_data[i]&0xE0)<<1);
                buff2[i+1]=((yuv_data[i+1]<<1)&0xFE) | ((yuv_data[i]>>7));
        }
}

void frame16to32 (unsigned int *buff2,unsigned short int *yuv_data, int len)
{
	int i;

	for(i=0;i<len;i++)
	{
		buff2[i]=((yuv_data[i]&0x7800)<<9) | ((yuv_data[i]&0x03E0) << 6) | ((yuv_data[i]&0x001F)<<3);
	}
}

void frame24to32 (unsigned int *buff2,unsigned char *yuv_data, int len)
{
	int i,j;

	j=0;
	for(i=0;i<len;i++)
	{
		buff2[i]=yuv_data[j+1]<<8 | yuv_data[j+2] | yuv_data[j] << 16 ;
		j+=3;
	}
}

void frame16to24 (unsigned char *buff2,unsigned char *yuv_data, int len)
{
	int i,j;

	j=0;
	for(i=0;i<(len*3);i+=3)
	{
		buff2[i]=yuv_data[j]&0x1F;
		buff2[i+1]=0;
		buff2[i+2]=0;
		j+=2;
	}
}
