/* Copyright 2000 Tommy Johnson  All Rights Reserved
**
** Permission is hereby granted to copy, reproduce, redistribute or otherwise
** use this software as long as: there is no monetary profit gained
** specifically from the use or reproduction of this software, it is not
** sold, rented, traded or otherwise marketed, and this copyright notice is
** included prominently in any copy made.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
** SOFTWARE IS AT THE USER'S OWN RISK.
*/

#include<stdio.h>
#include<stdlib.h>
#include<sys/types.h>
#include<sys/uio.h>
#include<unistd.h>
#include<ctype.h>
#include<sys/time.h>
#include<sys/mman.h>
#include<sys/fcntl.h>
#include<sys/signal.h>
#include<errno.h>
#include <machine/soundcard.h>
#include<machine/ioctl_meteor.h>
#include<X11/Xlib.h>
#include<X11/StringDefs.h>
#include<X11/Intrinsic.h>
#include<X11/Shell.h>
#include<X11/Xaw/Label.h>
#include<X11/Xaw/Command.h>
#include<X11/Xaw/Toggle.h>
#include<X11/Xaw/Form.h>
#include<X11/Xaw/Scrollbar.h>

#include"ppmio.h"

#define BPP 4

int audioinit(char *dev,int rate,int size, int stereo);

#ifdef SH_MEM
/* shared memory code based on mpeg2play code, which is based on the 
** mpegplay player from berkeley
*/
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>   
static XShmSegmentInfo shminfo1;
static int CompletionType=-1;
#endif

int doshm=0;

static char *fallback[] = { 
	"videoplay.title: Video",
	"videoplay.main.quit.label: Quit",
	"videoplay.main.grab.label: Grab",
	"videoplay.main.grabcon.label: Continuous Grab",
	"videoplay.main.fpslabel.label: FPS:",
	"videoplay.main.fpslabel.borderWidth: 0",
	"videoplay.main.fps.label: 000",
	(char*)NULL
	};


/* enqueue at tail.  dequeue at head.
** this is used for both the audio, and video.  (seperate instances)
**  head and tail are in samples, NOT bytes.  (in video, a sample is a frame)
*/
typedef struct
{
        int head;
	int tail;
	int len;    /* length of the buffer in samples  */
	int highwat,lowwat;   /* in samples...  */
	unsigned char *buff;
	int size;   /* size of a sample, in bytes */
} ringbuffer;

/* size is size of a sample.  len is how many samples the buffer will hold
*/

ringbuffer *ringbuffermalloc(int size,int len)
{
	ringbuffer *rb;

	rb=mmap((caddr_t)0,sizeof(ringbuffer)+(size*len)+4096,PROT_READ|PROT_WRITE,MAP_ANON|MAP_INHERIT|MAP_SHARED,-1,0);

	if (rb==MAP_FAILED)
	{
		return NULL;
	}              
	rb->buff=rb+sizeof(ringbuffer);
	rb->head=0;
	rb->tail=0;
	rb->len=len-1;
	rb->lowwat=len/4;
	rb->highwat=len*0.75;
	rb->size=size;

	return rb;
}

#define ringbufferlen(rb) ((rb->head>rb->tail)?((rb->len-rb->head)+rb->tail):(rb->tail-rb->head))

#define ringbufferincrement(rb,i)   ((i>=rb->len)?(i=0):(i++))

/* len is in samples, NOT bytes
*/

void ringbufferinsert(ringbuffer *rb,unsigned char *dat, int len)
{
#ifdef DEBUG
	fprintf(stderr,"insert len=%d   head=%d tail=%d\n",len,rb->head,rb->tail);
#endif
	if (len < (rb->len-rb->tail))
	{
		memcpy(rb->buff+(rb->tail*rb->size),dat,len*rb->size);
		rb->tail+=len;
	}
	else
	{
		memcpy(rb->buff+(rb->tail*rb->size),dat,rb->size*(rb->len-rb->tail));
		memcpy(rb->buff,dat+(rb->size*(rb->len-rb->tail)),rb->size*(len-(rb->len-rb->tail)));
		rb->tail=len-(rb->len-rb->tail);
	}
}

/* note that len is in samples, NOT bytes
*/
int ringbufferwrite(ringbuffer *rb, int fd, int len)
{
	struct iovec vector[2];

	if (ringbufferlen(rb)<(len*rb->size))
		return;

	if (len < (rb->len-rb->head))
	{
		vector[0].iov_base=rb->buff+(rb->head*rb->size);
		vector[0].iov_len=len*rb->size;
		rb->head+=len;
		return writev(fd,vector,1);
	}
	else
	{
		vector[0].iov_base=rb->buff+(rb->head*rb->size);
		vector[0].iov_len=(rb->len-rb->head)*rb->size;
		vector[1].iov_base=rb->buff;
		vector[1].iov_len=(len-(rb->len-rb->head))*rb->size;
		rb->head=(len-(rb->len-rb->head));
		return writev(fd,vector,2);
	}
}

void * sharedmalloc(int size)
{
	void *t;
	t=mmap((caddr_t)0,size,PROT_READ|PROT_WRITE,MAP_ANON|MAP_INHERIT|MAP_SHARED,-1,0);

	if (t==MAP_FAILED)
	{
		return NULL;
	}              
	return t;
}

XtAppContext app;
Widget shell,form,quitw,grabw,grabcon,fpsw,fpslabelw;
Widget bri,con,gain;
extern int errno;
int length;   /* length limit, stop reading video file after this many frames (or negative for read to EOF)  */

ringbuffer *vidbuff,*audbuff;
pid_t readerpid,audiowriterpid,syncpid;

int size;

int w,h;         /* image dimentions  */
unsigned int *imagedat;   /* X image data buffer, pointed to by ximage */
Widget image;
int *frame,frames;

void (*frametodisp)();

void frame32to16 (unsigned char *imagedat,unsigned char *rawimagedat)
{
	int x,p=0;
	for(x=0;x<(w*h*4);x+=4)
	{
		imagedat[p]=((rawimagedat[x]&0xF8)>>3) | ((rawimagedat[x+1]&0x1C)<<3);
		imagedat[p+1]=((rawimagedat[x+2]&0xF8)) | (((rawimagedat[x+1])&0xE0)>>5);
		p+=2;
	}
}

void frame32to32 (unsigned int *imagedat,unsigned int *rawimagedat)
{
	int x,p=0;
	for(x=0;x<(w*h);x++)
	{
		imagedat[p]=rawimagedat[p];
		p++;
	}
}

void frame24to16 (unsigned char *imagedat,unsigned char *rawimagedat)
{
	int x,p=0;
	for(x=0;x<(w*h*3);x+=3)
	{
		imagedat[p]=((rawimagedat[x+2]&0xF8)>>3) | ((rawimagedat[x+1]&0x1C)<<3);
		imagedat[p+1]=((rawimagedat[x]&0xF8)) | (((rawimagedat[x+1])&0xE0)>>5);
		p+=2;
	}
}

void frame16to16 (unsigned char *buff2,unsigned char *yuv_data)
{
	int i;

	for(i=0;i<w*h*2;i+=2)
        {
                buff2[i]=(yuv_data[i]&0x1F) | ((yuv_data[i]&0xE0)<<1);
                buff2[i+1]=((yuv_data[i+1]<<1)&0xFE) | ((yuv_data[i]>>7));
        }
}

void frame16to32 (unsigned int *buff2,unsigned short int *yuv_data)
{
	int i;

	for(i=0;i<w*h;i++)
	{
		buff2[i]=((yuv_data[i]&0x7800)<<9) | ((yuv_data[i]&0x03E0) << 6) | ((yuv_data[i]&0x001F)<<3);
	}
}

void frame24to32 (unsigned int *buff2,unsigned char *yuv_data)
{
	int i,j;

	j=0;
	for(i=0;i<w*h;i++)
	{
		buff2[i]=yuv_data[j+1]<<8 | yuv_data[j+2] | yuv_data[j] << 16 ;
		j+=3;
	}
}

void frame16to24 (unsigned char *buff2,unsigned char *yuv_data)
{
	int i,j;

	j=0;
	for(i=0;i<(w*h*3);i+=3)
	{
		buff2[i]=yuv_data[j]&0x1F;
		buff2[i+1]=0;
		buff2[i+2]=0;
		j+=2;
	}
}

void frameyuv16to32(unsigned char *targ,unsigned char *yuv_data)
{
	convertYUV2RGB(w,h,yuv_data,yuv_data+(w*h)+(w*h/2),yuv_data+(w*h),targ,0);

#if 0
	for(y=0;y<h;y++)
		for(x=0;x<w;x++)
	{
#if 1
		targ[(x+(y*w))*4]=yuv_data[(x+(y*w))]+yuv_data[(x/2)+((y/4)*w)+u]-128;
		targ[(x+(y*w))*4+2]=yuv_data[(x+(y*w))]+yuv_data[(x/2)+((y/4)*w)+v]-128;
		targ[(x+(y*w))*4+1]=yuv_data[(x+(y*w))]-targ[(x+(y*w))*4]-targ[(x+(y*w))*4+2];
		targ[(x+(y*w))*4+3]=0;
#else
		targ[(x+(y*w))*4]=yuv_data[i];
		targ[(x+(y*w))*4+1]=yuv_data[i];
		targ[(x+(y*w))*4+2]=yuv_data[i];
		targ[(x+(y*w))*4+3]=0;
#endif

	}
#endif
}

#define MAX(a,b)	(((a)>(b))?(a):(b))
#define MIN(a,b)	(((a)<(b))?(a):(b))

XImage *ximage;
GC gc;
Display *display;

static void quit()
{
	if (gc)
		XFreeGC(display,gc);
#ifdef SH_MEM
	if (doshm)
	{
		XShmDetach(display,&shminfo1);
		XDestroyImage(ximage);
		shmdt(shminfo1.shmaddr);
		shmctl(shminfo1.shmid,IPC_RMID,0);
	}
	else
#endif
	XDestroyImage(ximage);
	kill(readerpid,1);
	kill(audiowriterpid,1);
	kill(syncpid,1);

	exit(0);
} 

static int redraw_event(Widget dumw, Widget wig, XExposeEvent *ev)
{
	static gcexist=0;
	static int framecount=0;
	struct timespec interframe;
	int i;

	interframe.tv_sec=0;
	interframe.tv_nsec=1000000000/(30*4);  /* 1/4 of a frame */ 

	if (!gcexist)
	{
		gc=XCreateGC(display,XtWindow(image),0,0);
		gcexist=1;
	}

	while (framecount>=(*frame))   /* buzz loop till we're ready for the frame */
		nanosleep(&interframe,NULL);

//	frameyuv16to32(imagedat,vidbuff->buff+vidbuff->size*vidbuff->head);
//	frame16to32(imagedat,vidbuff->buff+vidbuff->size*vidbuff->head);
	frame32to32(imagedat,vidbuff->buff+vidbuff->size*vidbuff->head);
	ringbufferincrement(vidbuff,vidbuff->head);
	frames++;
	framecount++;

#ifdef SH_MEM
	if (doshm)
	{
		XShmPutImage(display,XtWindow(image),gc,ximage,0,0,0,0,w,h,True);
	}
	else
#endif
		XPutImage(display,XtWindow(image),gc,ximage,0,0,0,0,w,h); 

	XtAppAddTimeOut(app,1000/31,redraw_event,image);  /* note this is slightly early..  */
	return 0;
}

static void updatefps()
{
	char buff[1024];

	sprintf(buff,"%02d",frames);

	XtVaSetValues(fpsw,XtNlabel,buff,NULL);
	XtAppAddTimeOut(app,1000,updatefps,NULL);

	frames=0;
}

static void readerproc(int start,ppmstruct *ps,ringbuffer *vidbuff,ringbuffer *audbuff)
{
	unsigned char *y,*u,*v,*audio;
	struct timespec interframe;
	int frame=start,alen;

	interframe.tv_sec=0;
	interframe.tv_nsec=1000000000/(30*2);  /* 1/2 of a frame */ 
	audio=malloc(1472*4);   /* max audio per frame */

	while(1)
	{
		while(ringbufferlen(vidbuff)>vidbuff->lowwat)
			nanosleep(&interframe,NULL);

		while(ringbufferlen(vidbuff)<vidbuff->highwat)
		{
			y=vidbuff->buff+(vidbuff->tail*vidbuff->size);
			u=y+w*h;
			v=u+((w*h)/2);
			alen=ppmloadframe(ps,frame++,y,u,v,audio);
#ifdef DEBUG
			fprintf(stderr,"frame=%d alen=%d\n",frame,alen);
#endif
			ringbufferincrement(vidbuff,vidbuff->tail);
			if (alen>0)
				ringbufferinsert(audbuff,audio,alen/4);
		}
	}
}

static void audiowriterproc(int audfd, ringbuffer *audbuff)
{
	struct timespec interframe;
	int flen,rc;

	interframe.tv_sec=0;
	interframe.tv_nsec=1000000000/(30*4);  /* 1/2 of a frame */ 

	while(1)
	{
		flen=ppmframelen(*frame)/4;   /* in samples  */
		while(ringbufferlen(audbuff)<flen)
			nanosleep(&interframe,NULL);

		rc=ringbufferwrite(audbuff,audfd,flen);
#ifdef DEBUG
		fprintf(stderr," writing frame %d  len %d rc=%d errno=%d head= %d tail= %d\n",*frame,flen,rc,errno,audbuff->head,audbuff->tail);
#endif
		(*frame)++;
	}
}

static void syncproc(void)
{
	struct timespec interframe;
	interframe.tv_sec=0;
	interframe.tv_nsec=1000000000/(29.97);  /* 1/2 of a frame */ 

	while(1)
	{
		nanosleep(&interframe,NULL);
		(*frame)++;
	}
}

int main(int argc, char *argv[])
{
	extern char *optarg;
	char *filename=NULL;
	int c,i,dispdepth;
	int start;
	ppmstruct *ps;
	int imagesize;
	int audfd;

	start=0;
	length=-1;
	while ((c=getopt(argc,argv,"w:h:f:i:s:l:"))!=-1)
	switch (c)
	{
		case 's':
			sscanf(optarg,"%d",&start);
			break;
		case 'l':
			sscanf(optarg,"%d",&length);
			break;
		case 'f':
			filename=strdup(optarg);
			break;
	}

	ps=ppmopen(filename);
	if (ps==NULL)
	{
		fprintf(stderr,"can't open %s\n",filename);
		exit(1);
	}
	w=ppmgetwidth(ps);
	h=ppmgetheight(ps);

        shell=XtVaOpenApplication(&app,"video",0,0,&argc,argv,fallback,topLevelShellWidgetClass,(String)0);
	form=XtVaCreateManagedWidget("main",formWidgetClass,shell,NULL);
	quitw=XtVaCreateManagedWidget("quit",commandWidgetClass,form,NULL);
	grabw=XtVaCreateManagedWidget("grab",commandWidgetClass,form,XtNfromHoriz,quitw,NULL);
	grabcon=XtVaCreateManagedWidget("grabcon",toggleWidgetClass,form,XtNfromHoriz,grabw,NULL);
	fpslabelw=XtVaCreateManagedWidget("fpslabel",labelWidgetClass,form,XtNfromHoriz,grabcon,NULL);
	fpsw=XtVaCreateManagedWidget("fps",labelWidgetClass,form,XtNfromHoriz,fpslabelw,NULL);
	XtAddCallback(quitw,XtNcallback,(XtCallbackProc)quit,NULL);

	image=XtVaCreateManagedWidget("image",coreWidgetClass,form,XtNwidth,w,XtNheight,h,XtNfromVert,quitw,NULL);
	XtAddEventHandler(image,ExposureMask|StructureNotifyMask,FALSE,(XtEventHandler)redraw_event,NULL);

	display=XtDisplay(image);

	dispdepth=DefaultDepthOfScreen(XtScreen(image));
	fprintf(stderr,"display depth %d\n",dispdepth);
	switch (dispdepth)
	{
#ifdef BPP16
		case 16: frametodisp=frame16to16;  break;
		case 24: frametodisp=frame16to32;  break;
#else
		case 16: frametodisp=frame32to16;  break;
		case 24: frametodisp=frame32to32;  break;
#endif
		default: fprintf(stderr,"I can't do this depth\n");
	}
	imagesize=w*h*dispdepth;

#ifdef SH_MEM
	doshm=0;

	if (XShmQueryExtension(display))
		doshm=1;

	if (doshm)
	{
		XSync(display,True);
		ximage=XShmCreateImage(display,None,dispdepth,ZPixmap,0,&shminfo1,w,h);
		if (!ximage)
			{doshm=0; goto shmerror;}

		shminfo1.shmid=shmget(IPC_PRIVATE,imagesize,IPC_CREAT|0777);
		if (shminfo1.shmid<0)
			{doshm=0; XDestroyImage(ximage); goto shmerror;}
		shminfo1.shmaddr=(char*)shmat(shminfo1.shmid,0,0);
		if (shminfo1.shmaddr==((char*)-1))
			{doshm=0; XDestroyImage(ximage); goto shmerror;}
		ximage->data=shminfo1.shmaddr;
		shminfo1.readOnly=False;
		XShmAttach(display,&shminfo1);
		imagedat=shminfo1.shmaddr;
		CompletionType = XShmGetEventBase(display) + ShmCompletion;
		printf("attempting to share memory\n");
shmerror:
		XSync(display,False);
	}

#endif

	audfd=audioinit("/dev/audio",44100,16,1);
	vidbuff=ringbuffermalloc(w*h*BPP,16);
	audbuff=ringbuffermalloc(4,44100);
	frame=sharedmalloc(sizeof(int));

	if (audfd<0)
	{
		fprintf(stderr,"open of audio device failed\n");
		exit(1);
	}

	if (vidbuff==NULL)
	{
		fprintf(stderr,"allocation of video buffer failed\n");
		exit(1);
	}
	if (audbuff==NULL)
	{
		fprintf(stderr,"allocation of audio buffer failed\n");
		exit(1);
	}
	if (frame==NULL)
	{
		fprintf(stderr,"allocation of frame failed\n");
		exit(1);
	}

	*frame=0;

        switch(readerpid=fork())
	{
		case 0:
			readerproc(start,ps,vidbuff,audbuff);
			exit(0);
		break;
		case -1:
			fprintf(stderr,"fork for reader failed  %d\n",errno);
		break;
		default:
		break;
	}     

        switch(audiowriterpid=fork())
	{
		case 0:
			audiowriterproc(audfd,audbuff);
			exit(0);
		break;
		case -1:
			fprintf(stderr,"fork for audiowriter failed  %d\n",errno);
		break;
		default:
		break;
	}     

#if 0
        switch(syncpid=fork())
	{
		case 0:
			syncproc();
			exit(0);
		break;
		case -1:
			fprintf(stderr,"fork for syncproc failed  %d\n",errno);
		break;
		default:
		break;
	}     
#endif

	if (!doshm)   /* normal xlib, no shared memory */
	{
		imagedat=malloc(imagesize);
		ximage=XCreateImage(display,None,dispdepth,ZPixmap,0,imagedat,w,h,8,0);
	}

	updatefps();

	XtAppAddTimeOut(app,1000/8,redraw_event,image);

	XtRealizeWidget(shell);
	XtAppMainLoop(app);
	return 0;
}

int audioinit(char *dev,int rate,int size, int stereo)
{
        int fd;
	struct snd_size buffsize={5888,5888};

        fd=open(dev,O_WRONLY);
        if (fd<0)
                return -1;

        if (ioctl(fd,SNDCTL_DSP_SAMPLESIZE,&size)<0)
        {
                close(fd);
                return -1;
        }
        if (ioctl(fd,SNDCTL_DSP_STEREO,&stereo)<0)
        {
                close(fd);
                return -1;
        }
        if (ioctl(fd,SNDCTL_DSP_SPEED,&rate)<0)
        {
                close(fd);
                return -1;
        }
	if (ioctl(fd,AIOSSIZE,&buffsize)<0)
        {
                close(fd);
                return -1;
        }

        return fd;
}   
