#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<time.h>
#include<sys/time.h>
#include<ctype.h>
#include<machine/speaker.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/fcntl.h>
#include <signal.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<X11/Xlib.h>
#include<X11/StringDefs.h>
#include<X11/Intrinsic.h>
#include<X11/Shell.h>
#include<X11/Xaw/Label.h>
#include<X11/Xaw/Command.h>
#include<X11/Xaw/Form.h>

#define DEFINE
#include "cwchat.h"
#undef DEFINE

/*  By Tommy Johnson.
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    

static void quitcallback();
static void keydown(Widget w, char *,XButtonEvent *);
static void keyup(Widget w, char *,XButtonEvent *);
static void keyleave(Widget w, char *,XButtonEvent *);
static void startrecdata(int rfd,int spfil);
static void recdata(int rfd,int spfil);
static void newconnect(void *a,int b,XtInputId c);

pid_t childproc=0;   /* reciever process */
int init;          /* true on first keypress, to set first uptime to 0 */
int keydownflag;   /* true when key is down */
Time keydowntime;  /* timestamp of keydown */
Time keyuptime;    /* timestamp of last keyup */
int afid,rfid;     /* socket from listen, socket from accept */
int spfil;         /* FD to speaker device */

static void quitcallback()
{
	kill(childproc,15);
	exit(0);
}

static void keydown(Widget w, char *d,XButtonEvent *ev)
{
	if (!keydownflag)
	{
		keydownflag=1;
		keydowntime=ev->time;
	}
}

static void keyup(Widget w, char *d,XButtonEvent *ev)
{
	char buff[1024];
	if (keydownflag)
	{
		printf("keyup: up for %d, down for %d msec\n",keydowntime-keyuptime,ev->time-keydowntime);
		sprintf(buff,"%d,%d ",init?0:keydowntime-keyuptime,ev->time-keydowntime);
		write(rfid,buff,strlen(buff));
		init=0;
	}
	keydownflag=0;
	keyuptime=ev->time;
}

static void keyleave(Widget w, char *d,XButtonEvent *ev)
{
	keydownflag=0;
	keyuptime=ev->time;
}


int gettime(void)
{
	struct timeval tv;
	struct timezone tz;

	tz.tz_minuteswest=0;   /* ignored...  */
	tz.tz_dsttime=0;
	gettimeofday(&tv,&tz);
	return tv.tv_usec/1000+tv.tv_sec*1000;  /* return time in ms  */
}


static void newconnect(void *a,int b,XtInputId c)
{
	struct sockaddr_in cli_addr;
	int nfid;
	int clilen;

	nfid=accept(afid,(struct sockaddr*)&cli_addr,&clilen);
	if (nfid>=0)
	{
		if (rfid>=0)
			close(rfid);
		rfid=nfid;
		startrecdata(rfid,spfil);
	}
}

/* this is forked off as a child process...  no X calls
*/
static void startrecdata(int rfd,int spfil)
{
	if (childproc!=0)
		kill(childproc,15);

	switch(childproc=fork())
	{
		case -1: fprintf(stderr,"fork of reciever kid failed...\n");
			exit(1);
		break;
		case 0:
			recdata(rfid,spfil);
		break;
	}
}

static void recdata(int rfid,int spfil)
{
static Time lasttim;
static int len=0;
static char buff[1024];

	int i,tu,td,tl;
	Time curtim;
	tone_t ton;

	lasttim=gettime()-1000;  /* start at 1 second ago */

	do
	{
		i=read(rfid,&buff[len],sizeof(buff)-len);
		if (i>=0)
			len+=i;
		buff[len]=0;

		while(strstr(buff," "))  /* If we have a complete record */
		{
			sscanf(buff,"%d,%d",&tu,&td);
			i=0;
			while(buff[i]!=' ')
				i++;
			i++;
			memcpy(buff,&buff[i],len-i+1);
			len-=i;

			curtim=gettime();
			tl=tu-(curtim-lasttim);
fprintf(stderr,"key up %d wait %d\n",tu, tl);
			if (tl<0)
				tl=0;

#if 0
			ton.frequency=0;
			ton.duration=tl/10;
			if (spfil>0)
				ioctl(spfil,SPKRTONE,&ton);
#else
			usleep(tl*1000);
#endif
			ton.frequency=1000;
			ton.duration=td/10;
			if (spfil>0)
				ioctl(spfil,SPKRTONE,&ton);
fprintf(stderr,"down %d\n",td);

			lasttim=gettime();
		}
	}
	while(i>0);
	exit(0);   /* kid go down the HOOOOLLLEEEE */
}

static char *fallback[] = {
	"cwchat.title: CWChat",
	"cwchat.main.quit.label: Quit",
	"cwchat.main.key.width: 50",
	"cwchat.main.key.height: 50",
	NULL
	};

int main(int argc, char *argv[])
{
	Widget form,quitw,key;
	struct sockaddr_in serv_addr;
	int listener;

	init=1;
	rfid=-1;

	if ((spfil=open("/dev/speaker",O_RDWR))<0)
	{
		perror("main: open of /dev/speaker failed.  Ignoring the problem...\n");
	}

	shell=XtVaOpenApplication(&app,"cwchat",0,0,&argc,argv,fallback,topLevelShellWidgetClass,NULL);

	listener=(argc<=1);
	if (listener)
	{
		fprintf(stderr,"listening for incoming connection.\n");
		if ((afid=socket(PF_INET,SOCK_STREAM,0))<0)
		{
			perror("socket:");
			exit(1);
		}
		serv_addr.sin_family=AF_INET;
		serv_addr.sin_addr.s_addr=htonl(INADDR_ANY);
		serv_addr.sin_port=htons(CWTCPPORT);
		if (bind(afid,(struct sockaddr*)&serv_addr,sizeof(serv_addr))<0)
		{
			perror("bind:");
			exit(1);
		}
		listen(afid,5);
	}
	else
	{
		fprintf(stderr,"connecting to %s\n",argv[1]);
		rfid=openport(argv[1],CWTCPPORT);
		if (rfid<0)
		{
			fprintf(stderr,"connect failed...\n");
			exit(1);
		}
		if (rfid>=0)
			startrecdata(rfid,spfil);
	}

	keydownflag=0;

	form=XtVaCreateManagedWidget("main",formWidgetClass,shell,NULL);
	quitw=XtVaCreateManagedWidget("quit",commandWidgetClass,form,NULL);
	XtAddCallback(quitw,XtNcallback,(XtCallbackProc)quitcallback,NULL);
	key=XtVaCreateManagedWidget("key",coreWidgetClass,form,XtNfromVert,quitw,NULL); 
	XtAddEventHandler(key,ButtonPressMask,FALSE,(XtEventHandler)keydown,NULL);
	XtAddEventHandler(key,ButtonReleaseMask,FALSE,(XtEventHandler)keyup,NULL);
	XtAddEventHandler(key,LeaveWindowMask,FALSE,(XtEventHandler)keyleave,NULL);

	if (listener)
		XtAppAddInput(app,afid,(XtPointer)XtInputReadMask,(XtCallbackProc)newconnect,NULL);

	XtRealizeWidget(shell);
	XtAppMainLoop(app);
	return 0;
}	
