#ifndef LAMPS_H
#define LAMPS_H

/* $Id: lamps.h,v 1.5 2010/12/10 20:22:22 protius Exp $
**
** Tommy's Qswitch Trigger, to observe the pump light of a pulsed laser,
** and trigger an active qswitch.
** Copyright (C) 2010 Tommy Johnson
** 
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/



#ifdef DEFINE
#define extern 
#else
#define extern extern
#endif

#undef extern

/* call on startup, for hardware init 
*/
void lamps_init(void);

/* Set various config values
*/
void lamps_offsetset(unsigned int o);
void lamps_risejitterset(unsigned int o);
void lamps_decisionset(unsigned int o);

/* Writes the config values to flash memory.
** may need to call lamps_init to be re-read
*/
void lamps_saveconfig(void);

/* Manual trigger, intended for testing the qswitch driver
*/
void lamps_fire(void);

/* show current configuration
**  calls writeStrLong, which cli exports
*/
void lamps_show(void);

/* Called by cli on each loop.  Will generate the status report,
** and then return to the IDLE state.   (It /must/ be called, or 
** it will never return to the IDLE state, and thus only fire once.)
*/
void lamps_status(void);

#endif
