/******************************************************************************
 *
 * $Workfile: config.h $
 *
 * This module provides information about the project configuration
 *
 * $History: config.h $
 *
 *****************************************************************************/
#ifndef INC_CONFIG_H
#define INC_CONFIG_H

#include <io.h>
#include <sys/inttypes.h>

// Handy Macros
// service the watchdog timer
#define WDOG()              (WDTCTL = (WDTCTL & 0xFF) + WDTPW + WDTCNTCL)

// If we don't use a tasker, define swap() here
#define swap()              WDOG()

#define CLOCKMULT 120

// Oscillator Frequencies
//#define LFXT1CLK            (6.78e6)
#define LFXT1CLK            (32768)
#define XT2CLK
#define DCOCLK              (LFXT1CLK*CLOCKMULT*2)

// Clock Frequencies
#define ACLK                (LFXT1CLK)
#define MCLK                (DCOCLK)
#define SMCLK               (DCOCLK)

// System Data Rates
#define HOST_BAUD           (9600ul)

// Port Usage Definitions & Access Macros
// Port 1 Bits
// (not used)

// Port 1 Inits
#define P1SEL_INIT          (0x00)      // all pins are port pins
#define P1OUT_INIT          (0x00)      // start with all output pins LOW
#define P1DIR_INIT          (0x00)      // pin P1.4 is the button, all pins are inputs

/* SEL:   clear for port, set for other function
** DIR:   set for out, clear for input
*/

// Port 2 Macros
#define HOST_TX_BIT         BV(4)       // SCI0 TX output
#define HOST_RX_BIT         BV(5)       // SCI0 RX input
#define HOST_UART_BITS      (HOST_TX_BIT | HOST_RX_BIT)

#define P2SEL_INIT          (HOST_UART_BITS | BV(1)|BV(2)|BV(3)) // Use UART bits and timerB outputs  
#define P2OUT_INIT          (0)
#define P2DIR_INIT          (~(HOST_RX_BIT | BV(3)))  // RX and TB2 are input

// Port 3 Inits
#define P3SEL_INIT          (BV(7)|BV(6)|BV(5)|BV(4))    // TB6 - TB3
#define P3OUT_INIT          (0x00)      // start with all output pins LOW
#define P3DIR_INIT          (0)      // all are input

// Port 4 Inits
#define P4SEL_INIT          (BV(0)|BV(1)) // UART is P4.0, P4.1
#define P4OUT_INIT          (0x00)      // start with all output pins LOW
#define P4DIR_INIT          (~BV(1))      //  all are out, except for RX

// Port 5 Inits
#define P5SEL_INIT          (0x00)      // all pins are port pins
#define P5OUT_INIT          (0x00)      // start with all output pins LOW
#define P5DIR_INIT          (0xFF)      // all pins are 

// Port 6 Inits
#define P6SEL_INIT          (0xFF)      // 
#define P6OUT_INIT          (0x00)      // start with all output pins LOW
#define P6DIR_INIT          (0x00)      // all pins are inputs

#define TESTPUTS(x)  usart1Puts(x)

#ifdef DEFINE
#define extern
#else
#define extern extern
#endif

#undef extern

#endif
