#include <stdio.h>
#include <stdlib.h>

#include "multiplex.h"

static char *rcsid="$Id: expose.c,v 1.4 2005/10/24 03:32:12 protius Exp $";
/* Copyright (c) 2005 Tommy Johnson  All Rights Reserved
 */


int main(int argc, char *argv[])
{
	Multiplex *m;
	int exposure;

	if (argc<2)
	{
		fprintf(stderr,"expose time\n open the shutter for time milliseconds\n");
	}
	sscanf(argv[1],"%d",&exposure);

	m=multiplexInit("/dev/ppi0",MULTIPLEX_NOCALIBRATE);

	if (m==NULL)
	{
		fprintf(stderr,"open of multiplex device failed.\n");
		return 1;
	}

	return multiplexExpose(m,exposure);
}
