#include<stdio.h>
#include<sys/soundcard.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>

/* 
**
** Tommy's hop watcher.
** Copyright (C) 2011 Tommy Johnson
** 
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
** 
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
** 
*/



extern char *optarg;
extern int optind;
extern int optopt;
extern int opterr;
extern int optreset;

int main(int argc, char *argv[])
{
	int c;
	int devhandle;
	int i;
	int amp=500;
	
	int rate=48000,size=16,stereo=0;
	long long int sample=0;
	char dev[1024];

	unsigned char *buffer;
	int bufferlen;
	int event=0;

	strcpy(dev,"/dev/dsp");

	while ((c=getopt(argc,argv,"r:a:d:h?"))!=-1)
	switch (c)
	{
		case 'r':
			sscanf(optarg,"%i",&rate);
		break;
		case 'a':
			sscanf(optarg,"%i",&amp);
		break;
		case 'd':
			strcpy(dev,optarg);
		break;
		case 'h':
			fprintf(stderr,"hop - watches for peaks, and saves them in files\n"
			"-r num - set sample rate\n"
			"-a amp - set event amplitude\n"
			"-d dev - set device to use\n"
			);
			exit(0);
		break;
	}

	if (!(devhandle=open(dev,O_RDONLY)))
	{
		perror("open:");
		exit(1);
	}

	if (ioctl(devhandle,SNDCTL_DSP_SPEED,&rate)<0)
		perror("set speed:");
	if (ioctl(devhandle,SNDCTL_DSP_STEREO,&stereo)<0)
		perror("set stereo:");
	if (ioctl(devhandle,SNDCTL_DSP_SAMPLESIZE,&size)<0)
		perror("set samplesize:");

	fprintf(stderr,"speed:%d\nstereo:%d\nsample size:%d\n",rate,stereo,size);

	bufferlen=rate*4;   /* 2 seconds of buffer...  */

	if (!(buffer=malloc(bufferlen)))
	{
		fprintf(stderr,"buffer malloc failed");
		exit(2);
	}

	while(1)
	{
		unsigned char *buffer2=buffer+(bufferlen/2);
		long long int found=0;
		int blen;
		FILE *out;
		char name[1024];

		c=read(devhandle,buffer2,bufferlen/2);
		blen=c/2;
		for(i=0;i<blen;i++)
		{
			int d=(signed short)(buffer2[i*2] | (buffer2[i*2+1]<<8));
			if (abs(d)>amp)
			{
				found=sample+i+rate/2;    /* we want to center the event, but note offset from buffer2  */
				event++;
				fprintf(stderr,"event %d at %lld\n",event,sample);
				break;
			}

		}
		if (found)
		{
			snprintf(name,sizeof(name),"event%04d.dat",event);
			out=fopen(name,"w");
			for(i=0;i<bufferlen/2;i++)
			{
				int d=(signed short)(buffer[i*2] | (buffer[i*2+1]<<8));
				if ((found>0) && ((i+sample)>=found) && ((i+sample)<=(found+rate)))
					fprintf(out,"%lld %d \n",sample+i, d);
			}
			fclose(out);
			found=0;
		}
		memcpy(buffer,buffer2,bufferlen/2);
		sample+=blen;
	}

	close(devhandle);
}
