/******************************************************************************
 *
 * $Workfile: config.h $
 *
 * This module provides information about the project configuration
 *
 * $History: config.h $
 *
 *****************************************************************************/
#ifndef INC_CONFIG_H
#define INC_CONFIG_H

#define WITH_DISABLE_WDT
#define BV(x)   (1<<(x))

#include <sys/inttypes.h>

#include <legacymsp430.h>
//#include <msp430x44x.h>
#include <msp430.h>

// Handy Macros
// service the watchdog timer
#define WDOG()              (WDTCTL = (WDTCTL & 0xFF) + WDTPW + WDTCNTCL)

// If we don't use a tasker, define swap() here
#define swap()              WDOG()

#define CLOCKMULT 120

// Oscillator Frequencies
//#define LFXT1CLK            (6.78e6)
#define LFXT1CLK            (32768)
#define XT2CLK
#define DCOCLK              (LFXT1CLK*CLOCKMULT*2)

// Clock Frequencies
#define ACLK                (LFXT1CLK)
#define MCLK                (DCOCLK)
#define SMCLK               (DCOCLK)

// System Data Rates
#define HOST_BAUD           (9600ul)

// Port Usage Definitions & Access Macros
// Port 1 Bits
// (not used)

/* SEL:   clear for port, set for other function
** DIR:   set for out, clear for input
*/

// Port 1 Inits
#define P1SEL_INIT          (0x00)      //
#define P1OUT_INIT          (0x00)      // start with all output pins LOW
#define P1DIR_INIT          (0x7F)      // 

// Port 2 Inits
#define HOST_TX_BIT         BV(4)       // SCI0 TX output
#define HOST_RX_BIT         BV(5)       // SCI0 RX input
#define HOST_UART_BITS      (HOST_TX_BIT | HOST_RX_BIT)

#define P2SEL_INIT          0xFF	// all pins are other 
#define P2OUT_INIT          (0)
#define P2DIR_INIT          0xD7

// Port 3 Inits
#define P3SEL_INIT          (BV(7)|BV(6)|BV(5)|BV(4))    // TB6 - TB3
#define P3OUT_INIT          (0x00)      // start with all output pins LOW
#define P3DIR_INIT          (0x0D)      // high 4 input, low four to delay chip

// Port 4 Inits
#define P4SEL_INIT          (BV(0)|BV(1)) // UART is P4.0, P4.1
#define P4OUT_INIT          (0x00)      // start with all output pins LOW
#define P4DIR_INIT          (~(BV(1)))      //  all are out, except for RX 

// Port 5 Inits
#define P5SEL_INIT          (0x00)      // all pins are port pins
#define P5OUT_INIT          (0x00)      // start with all output pins LOW
#define P5DIR_INIT          (0xFF)     // all are out, but i2c init will override

// Port 6 Inits
#define P6SEL_INIT          (0xFF)      // all are ADC 
#define P6OUT_INIT          (0x00)      // start with all output pins LOW
#define P6DIR_INIT          (0x00)      // all pins are inputs

#define TESTPUTS(x)  usart1Puts(x)

#ifdef DEFINE
#define extern
#else
#define extern extern
#endif

#undef extern

#endif
