#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <ctype.h>

/* Copyright 2008 Tommy Johnson
*/

#include "ppm.h"

#define IMAGEPIXEL(i,x,y) (i->data+((i->width*(y) + (x))*3))

Image *imageRead(char *fname)
{
	FILE *fd;

	fd=fopen(fname,"r");
	if (fd==NULL)
		return NULL;

	return imageReadFD(fd);
}

Image *imageReadFD(FILE *fd)
{
	char header[4096];
	Image *img;
	int p,len;

	len=fread(header,1,sizeof(header),fd);
	
	if ((strncmp(header,"P6\n",3)!=0) && (strncmp(header,"P5\n",3)!=0))
		return NULL;

	p=3;
	while((p<len) && (!isdigit(header[p])))
	{
		if (header[p]=='#')
			while((header[p]!='\n') && (p<len))
				p++;
		p++;
	}


	img=malloc(sizeof(*img));

	sscanf(header+p,"%d",&img->width);
	while (isdigit(header[p]) && (p<len))   /* walk over width */
		p++;
	while (!isdigit(header[p]) && (p<len)) /* walk over WS to height */
		p++;
	sscanf(header+p,"%d",&img->height);
	while (isdigit(header[p]) && (p<len))  /* walk over height */
		p++;
	while (!isdigit(header[p]) && (p<len)) /* walk over WS to number-colors */
		p++;
	sscanf(header+p,"%d",&img->bpp);
	while (isdigit(header[p]) && (p<len))  /* walk over number-colors */
		p++;
	p++;   /* skip newline */

	assert(img->bpp==255);
	img->data=malloc(img->width*img->height*3);

	memcpy(img->data,header+p,sizeof(header)-p);
	p=sizeof(header)-p;

	len=img->width*img->height*3;
	while(p<len)
	{
		p+=fread(img->data+p,1,len-p,fd);
	}

	fclose(fd);

	return img;
}

int imageWrite(Image *src, char *fname)
{
	FILE *fd;

	fd=fopen(fname,"w");
	if (fd==NULL)
		return -1;

	fprintf(fd,"P6\n%d %d\n%d\n",src->width, src->height, src->bpp);

	fwrite(src->data,1,src->width*src->height*3,fd);

	fclose(fd);
	return 0;
}


Image *imageCreate(int width, int height, int bpp)
{
	Image *img;

	img=malloc(sizeof(*img));
	img->width=width;
	img->height=height;
	img->bpp=bpp;
	assert(bpp==255);

	img->data=calloc(img->width*img->height*3,1);

	return img;
}


void imageSet(Image *dst, int r, int g, int b, int x1, int y1, int x2, int y2)
{
	int x,y;
	unsigned char *c;

	if (x1>x2)
	{
		x=x1;
		x1=x2;
		x2=x;
	}	
	if (y1>y2)
	{
		y=y1;
		y1=y2;
		y2=y;
	}	
	if (x1<0)
		x1=0;
	if (y1<0)
		y1=0;
	if (x2>dst->width)
		x2=dst->width;
	if (y2>dst->height)
		y2=dst->height;

	for(x=x1;x<x2;x++)
		for(y=y1;y<y2;y++)
		{
			c=IMAGEPIXEL(dst,x,y);
			c[0]=r;
			c[1]=g;
			c[2]=b;
		}
}

void imageBlit(Image *dst, Image *src,int xdst, int ydst, int x1,int y1, int x2, int y2 )
{
	unsigned char *s,*d;
	int w,h,x,y;

	if (xdst<0)
	{
		x1+=-xdst;
		xdst=0;
	}
	if (ydst<0)
	{
		y1+=-ydst;
		ydst=0;
	}
	if (x1<0)
	{
		xdst+=-x1;
		x1=0;
	}
	if (y1<0)
	{
		ydst+=-y1;
		y1=0;
	}
	if (xdst>dst->width)
		return;
	if (ydst>dst->height)
		return;
	if (x2<0)
		return;
	if (y2<0)
		return;
	if (x2>src->width)
		x2=src->width;
	if (y2>src->height)
		y2=src->height;

	w=x2-x1;
	h=y2-y1;
	if ((xdst+w)>dst->width)
		w=dst->width-xdst;
	if ((ydst+h)>dst->height)
		h=dst->height-ydst;

	fprintf(stderr," blit  %d, %d from %d,%d %d,%d\n",xdst,ydst,x1,y1,x2,y2);
	for(x=0;x<w;x++)
		for(y=0;y<h;y++)
		{
			d=IMAGEPIXEL(dst,x+xdst,y+ydst);
			s=IMAGEPIXEL(src,x+x1,y+y1);
			d[0]=s[0];
			d[1]=s[1];
			d[2]=s[2];
		}
}

unsigned char *imageRow(Image *img, int row)
{
	return IMAGEPIXEL(img,0,row);
}

void imageFree(Image *img)
{
	free(img->data);
	free(img);
}
