/* $Id: panel.h,v 1.12 2019/02/15 20:48:43 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#ifndef PANEL_H
#define PANEL_H

#ifdef DEFINE
#define extern 
#else
#define extern extern
#endif

extern volatile unsigned int msecclock;

#undef extern

/* This is support functions for the control panel.  It also includes
** a millisecond clock, which is used to poll the interlock input, and
** generating timing for auto-fire mode.
*/

/* init port direction regs used by the panel.
*/
void panel_init(void);

/* read interlock status
*/
int panel_getinterlock(void);

/* update interlock LED
*/
void panel_setinterlock(int);

/* update ready LED (the final READY, the OSC and AMP ready LEDs are driven
** by hardware.
*/
void panel_setready(int);

/* Update the relay drivers
*/
void panel_setpoweron(int v);
void panel_setdumprelay(int v);
void panel_setsparerelay(int v);

/* read the mode switch.  returns a number from 0 to 5 or -1 if it hasn't
** changed.  This is polled in main, and the CLI gets nice debounced
** the-switch-has-moved events.
*/
int panel_moderead(void);

/* check the charge button.  Polled in main, and passed to the CLI debounced.
*/
int panel_charge(void);

/* check the fire button.  Polled in main, and passed to the CLI debounced.
*/
int panel_fire(void);
int panel_dumpdown(void);
int panel_dumpup(void);
int panel_keyswitchdown(void);
int panel_keyswitchup(void);

/* start auto-fire
**  period is in milliseconds.  0 to disable.
**  called by cli when fire button is pressed and autofire is enabled.
*/
void panel_autofire(int period);

/* Dumps some relevent numbers for hardware testing
*/
void panel_debug(void);


#endif
