
/* $Id: configuration.h,v 1.11 2018/06/03 17:53:56 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/* Bits in the flags var
*/
#define OSCENABLE 	0x01
#define AMP0ENABLE	0x02
#define AMP1ENABLE	0x04
#define AMP2ENABLE	0x08
#define AUTOCHARGE	0x10
#define AUTOFIRE	0x20
#define QSWITCHENABLE	0x40

typedef struct configuration
{
	unsigned int magicnum;		/* magic number, to identify valid block  */
	unsigned int offsetqswitch;    /* in clock ticks  */
	unsigned int offsetosc;
	unsigned int offsetamp0;
	unsigned int offsetamp1;
	unsigned int offsetamp2;

	unsigned int oscvoltage;
	unsigned int oscmaxchargetime;

	unsigned int amp0voltage;
	unsigned int amp0maxchargetime;
	unsigned int amp1voltage;
	unsigned int amp1maxchargetime;
	unsigned int amp2voltage;
	unsigned int amp2maxchargetime;

	unsigned int flags;

	unsigned int fireperiod;      /* If AUTOFIRE, we will fire this frequently  */
	unsigned int firedelayfine;   /* a delay in usec added to the timestamp when we get a fire signal */
	unsigned int firedelay;       /* a delay msec before we fire  */
	
} configuration;

#ifdef DEFINE
#define extern 
#else
#define extern extern
#endif

extern configuration curconfig;

#undef extern

/* after flashing firmware, will be 0
** after erase, will be 0xFFFF
**
** We will have two seperate config pages, the active one will be VALID,
** the other will be ERASED.  When we save config, we write the new config
** to the ERASED one, copying from the old one as needed, and then ERASE
** the old one.  So the active one will swap back and forth.
*/
#define CONFIGURATION_VALID 0x549D
#define CONFIGURATION_ERASED 0xFFFF

/* This is actually the number of positions on the mode switch,
** rather than how many of the above struct fits in 512 bytes.
*/
#define CONFIGURATION_NUM 6

/* Load the specified configuration into RAM curconfig
*/
void configuration_load(int num);

/* Write the RAM curconfig to the specified FLASH slot
** returns non-zero on failure
*/
int configuration_saveconfig(configuration *conf, int num);

/* Return a pointer to the specified FLASH slot.  (to show a
** config without loading it.)
*/
configuration *configuration_get(int num);

#endif
