
/* $Id: amp2.h,v 1.3 2018/02/16 21:19:55 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#ifndef AMP2_H
#define AMP2_H

void amp2_init(void);

/* set or clear charge enable
*/
int amp2_enable_get(void);

int amp2_chargetime(void);
void amp2_maxchargetimeset(unsigned int);

void amp2_enable_set(int);

/* returns true when the charger has achieved its set point
*/
int amp2_ready();

/* Set the raw dac value
*/
int amp2_dacset(int dv);

/* set the voltage set point
*/
int amp2_voltageset(int v);

/* read the current set point
*/
int amp2_voltageget(void);

/* read the current voltage
*/
int amp2_voltageread(void);

int amp2_energyread(void);

/* Returns true on the rising edge of the ready flag
*/
int amp2_readycheck(void);

/* Returns true of the energy control module has power applied
*/
int amp2_power_get(void);


#endif
