#include "config.h"
#include <string.h>
#include <stdio.h>

/* $Id: osc.c,v 1.17 2012/12/16 20:23:25 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#include "adc.h"
#include "osc.h"
#include "panel.h"
#include "cli.h"

#define SDA_INIT	P4OUT&=~BV(4)
#define SDA_CLEAR	P4DIR&=~BV(4)
#define SDA_SET		P4DIR|=BV(4)
#define SDA_READ	(P4IN&BV(4))

#define SCL_INIT	P4OUT&=~BV(3)
#define SCL_CLEAR	P4DIR&=~BV(3)
#define SCL_SET		P4DIR|=BV(3)

/* the enable hardware is active low  */
#define ENABLE_GET	(!(P1OUT&BV(3)))
#define ENABLE_CLEAR	P1OUT|=BV(3)
#define ENABLE_SET	P1OUT&=~BV(3)

#define POWER_GET	(P1IN&BV(4))

#define READY_GET	(P1IN&BV(2))
#define VOLTAGE_ADC	3

// curvefit values for converting volts to DAC units
#define VOLTSLOPE       (0.199218750)
#define VOLTOFFSET      (518.0)

#define DEVICE(x)	osc##x

/* failsafe max for the DAC  
*/
#define MAXDAC		0x3200

/* capacitance in uf, for calculating energy
*/
#define LAMPCAP	250

#include "i2c.c"
#include "energycontrol.c"
