
/* $Id: configuration.h,v 1.7 2012/12/25 04:03:20 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/* Bits in the flags var
*/
#define OSCENABLE 	1
#define AMPENABLE	2
#define AUTOCHARGE	4
#define AUTOFIRE	8
#define QSWITCHENABLE	16

typedef struct configuration
{
	unsigned int magicnum;		/* magic number, to identify valid block  */
	unsigned int offsetqswitch;    /* in clock ticks  */
	unsigned int offsetamp;
	unsigned int offsetosc;

	unsigned int ampvoltage;
	unsigned int ampmaxchargetime;
	unsigned int oscvoltage;
	unsigned int oscmaxchargetime;
	unsigned int flags;

	unsigned int fireperiod;   /* If AUTOFIRE, we will fire this frequently  */
	
} configuration;

#ifdef DEFINE
#define extern 
#else
#define extern extern
#endif

extern configuration curconfig;

#undef extern

/* after flashing firmware, will be 0
** after erase, will be 0xFFFF
**
** We will have two seperate config pages, the active one will be VALID,
** the other will be ERASED.  When we save config, we write the new config
** to the ERASED one, copying from the old one as needed, and then ERASE
** the old one.  So the active one will swap back and forth.
*/
#define CONFIGURATION_VALID 0x549D
#define CONFIGURATION_ERASED 0xFFFF

/* This is actually the number of positions on the mode switch,
** rather than how many of the above struct fits in 512 bytes.
*/
#define CONFIGURATION_NUM 6

/* Load the specified configuration into RAM curconfig
*/
void configuration_load(int num);

/* Write the RAM curconfig to the specified FLASH slot
** returns non-zero on failure
*/
int configuration_saveconfig(configuration *conf, int num);

/* Return a pointer to the specified FLASH slot.  (to show a
** config without loading it.)
*/
configuration *configuration_get(int num);

#endif
