#ifndef CLI_H
#define CLI_H

/* $Id: cli.h,v 1.7 2012/12/24 15:31:06 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
** 
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/


#ifdef DEFINE
#define extern 
#else
#define extern extern
#endif

#define CHARGER_OFF 0
#define CHARGER_TURNINGON 1
#define CHARGER_IDLE 2
#define CHARGER_CHARGING 3
#define CHARGER_READY 4
#define CHARGER_FIRING 5
#define CHARGER_FAULT 6

extern char charger_state;

extern unsigned int turnondelay;

#undef extern

void cli_init(void);
void cli_nextchar(unsigned int ch);

void cli_dumphex(int i);

void writeStrLong(const char *str);

void charge(void);

void dump(void);

/* call when the power is turned on  (key switch) */
void powerOn(void);

/* If something goes wrong, call this
*/
void fault(char *msg);

/* The tim arg is a timestamp, for the lamps clock
**  pass in a 1, if you don't care  (It'll fire within a couple of milliseconds)
*/
void fire(int tim);

/* Call when a ready line goes high
*/
void ready(void);

/* Call when the fire sequencer finishes
*/
void firecomplete(void);

#endif
