
#ifndef LUX_REGISTERS_H
#define LUX_REGISTERS_H

/*
 * Copyright 2002 Tommy Johnson
 *
 * lots of consulting of 
 * alpm.c, which is
 * Copyright (c) 1998, 1999 Nicolas Souchu
 * All rights reserved.
 * and xrpu.c, which is
 *
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <phk@FreeBSD.org> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.   Poul-Henning Kamp
 * ----------------------------------------------------------------------------
 *
 * Major parts copied from Creative's demo driver
 *
 *
 * lux driver
 * $FreeBSD: src/share/examples/drivers/make_pci_drive.sh,v 1.1.2.2 1999/08/29 16:45:01 peter Exp $
 */

#define LUX_VENDOR_CREATIVE	0x1287
#define LUX_DEV_PCI_ID		0x001e     /* pci device id of your device */       

/* LS220 registers:
*/
#define LUX_HOST_CONTROL			(0x10 >> 2)
#define LUX_IRQ_STATUS				(0x14 >> 2)
#define LUX_IRQ_CLEAR				(0x18 >> 2)
#define LUX_IRQ_SET				(0x1C >> 2)
#define LUX_IRQ_MASK				(0x20 >> 2)

#define LUX_DRAM_CONTROL			(0x80 >> 2)

#define LUX_DSP_BOOT_ADDR			(0x100 >> 2)
#define LUX_DSP_RUN				(0x104 >> 2)

#define LUX_MPEG_VIDEO_CONTROL			(0x180 >> 2)
#define LUX_MPEG_VIDEO_SETUP			(0x184 >> 2)
#define LUX_MPEG_VIDEO_FIFO_START		(0x188 >> 2)
#define LUX_MPEG_VIDEO_FIFO_END			(0x18C >> 2)
#define LUX_MPEG_VIDEO_FIFO_CURRENT		(0x190 >> 2)
#define LUX_MPEG_VIDEO_FIFO_FORCE		(0x194 >> 2)
#define LUX_MPEG_VIDEO_FIFO_ADD			(0x198 >> 2)
#define LUX_MPEG_VIDEO_FIFO_CURRENT_BYTES	(0x19C >> 2)
#define LUX_MPEG_VIDEO_FIFO_INTERUPT_BYTES	(0x1A0 >> 2)
#define LUX_MPEG_VIDEO_FIFO_TOTAL_BYTES		(0x1A4 >> 2
#define LUX_MPEG_VIDEO_FIFO_ERROR		(0x1A8 >> 2)
#define LUX_MPEG_MBWIDTH			(0x1AC >> 2)
#define LUX_MPEG_MBHEIGHT			(0x1B0 >> 2)
#define LUX_MPEG_VIDEO_DEBUG_1			(0x1B8 >> 2)
#define LUX_MPEG_VIDEO_DEBUG_2			(0x1BC >> 2)

#define LUX_SYNC_AUDIO_CONTROL			(0x200 >> 2)
#define LUX_SYNC_VID_CONTROL			(0x204 >> 2)
#define LUX_SYNC_VID_SYNC_STATUS		(0x208 >> 2)
#define LUX_SYNC_WAIT_LINE			(0x20C >> 2)
#define LUX_SYNC_FRAME_PERIOD			(0x210 >> 2)
#define LUX_SYNC_STC_INTERVAL			(0x214 >> 2)
#define LUX_SYNC_STC				(0x218 >> 2)
#define LUX_VIDEO_PTS_FIFO_START		(0x220 >> 2)
#define LUX_VIDEO_PTS_FIFO_END			(0x224 >> 2)
#define LUX_VIDEO_PTS_FIFO_WRITE		(0x228 >> 2)
#define LUX_VIDEO_PTS_FIFO_READ			(0x22C >> 2)
#define LUX_SYNC_IRQ_STATUS			(0x270 >> 2)
#define LUX_SYNC_IRQ_CONTROL			(0x274 >> 2)
#define LUX_SYNC_IRQ_SET			(0x278 >> 2)
#define LUX_SYNC_IRQ_CLEAR			(0x27C >> 2)

#define LUX_VIDEO_PTS			(0x250 >> 2)

#define LUX_GPIO_CONTROL		(0x350 >> 2)

#define LUX_VIDEO_PROCESSOR_CONTROL	(0x300 >> 2)
#define LUX_VIDEO_DRAM_LENGTH		(0x304 >> 2)
#define LUX_VIDEO_DISPLAY_ACTIVE_X	(0x308 >> 2)
#define LUX_VIDEO_DISPLAY_ACTIVE_Y	(0x30C >> 2)
#define LUX_VIDEO_BLANK_COLOR		(0x310 >> 2)
#define LUX_VIDEO_INT_HSYNC		(0x314 >> 2)
#define LUX_VIDEO_INT_VSYNC		(0x318 >> 2)

#define LUX_VIDEO_HORIZ_Y_OFFSET	(0x31C >> 2)
#define LUX_VIDEO_HORIZ_UV_OFFSET	(0x320 >> 2)
#define LUX_VIDEO_VERT_OFFSET		(0x324 >> 2)

#define LUX_I2C_READWRITE_2BYTES	(0x354 >> 2)
#define LUX_I2C_WRITE_3BYTES		(0x358 >> 2)
#define LUX_I2C_WRITE_4BYTES		(0x35C >> 2)
#define LUX_I2C_CONTROL			(0x364 >> 2)
#define LUX_I2C_READ_WRITE_DATA		(0x36C >> 2)
#define LUX_I2C_STATUS			(0x368 >> 2)

#define LUX_VIDEO_HSCALE		(0x328 >> 2)
#define LUX_VIDEO_VSCALE		(0x32C >> 2)
#define LUX_VIDEO_GAMMA			(0x330 >> 2)

#define LUX_OSD_OFFSET			(0x3D4 >> 2)
#define LUX_OSD_YSCALE_OFFSET		(0x3D8 >> 2)

#define LUX_DRAM_BASE			(0x200000 >> 2)
#define LUX_DSPMEM_BASE			(LUX_DRAM_BASE + (0x1f0000 >> 2))

/* Firmware registers:
**  These are in RAM, after the frame buffer, and interpreted by the DSP firmware
*/
#define LUX_DSP_MEM_LOCK		(LUX_DSPMEM_BASE+(0xFF78 >> 2))
#define LUX_DSP_AUDIO_CONF		(LUX_DSPMEM_BASE+(0xFF7C >> 2))
#define LUX_DSP_AC3_CONF		(LUX_DSPMEM_BASE+(0xFF80 >> 2))

#define LUX_DSP_KAROKE			(LUX_DSPMEM_BASE+(0xFF8C >> 2))

#define LUX_DSP_IRQ_MASK		(LUX_DSPMEM_BASE+(0xFFA4 >> 2))
#define LUX_DSP_IRQ_STATUS		(LUX_DSPMEM_BASE+(0xFFA8 >> 2))
#define LUX_DSP_IRQ_THRESHOLD		(LUX_DSPMEM_BASE+(0xFFAC >> 2))
#define LUX_DSP_VOLUME			(LUX_DSPMEM_BASE+(0xFFB0 >> 2))

#define LUX_DSP_PTS_FIFO_START		(LUX_DSPMEM_BASE+(0xFFD0 >> 2))
#define LUX_DSP_PTS_FIFO_END		(LUX_DSPMEM_BASE+(0xFFD4 >> 2))
#define LUX_DSP_PTS_FIFO_WRITE		(LUX_DSPMEM_BASE+(0xFFD8 >> 2))
#define LUX_DSP_PTS_FIFO_READ		(LUX_DSPMEM_BASE+(0xFFDC >> 2))

#define LUX_DSP_FIFO_START		(LUX_DSPMEM_BASE+(0xFFE0 >> 2))
#define LUX_DSP_FIFO_END		(LUX_DSPMEM_BASE+(0xFFE4 >> 2))
#define LUX_DSP_FIFO_WRITE		(LUX_DSPMEM_BASE+(0xFFE8 >> 2))
#define LUX_DSP_FIFO_READ		(LUX_DSPMEM_BASE+(0xFFEC >> 2))

#define LUX_DSP_COMMAND			(LUX_DSPMEM_BASE+(0xFFF0 >> 2))
#define LUX_DSP_STATUS			(LUX_DSPMEM_BASE+(0xFFF8 >> 2))

/* These values are written to LUX_DSP_COMMAND, to tell it to do 
** various things...
*/
#define LUX_DSP_COMMAND_NOP             0x00
#define LUX_DSP_COMMAND_AC3             0x80
#define LUX_DSP_COMMAND_MPEG1           0x81
#define LUX_DSP_COMMAND_MPEG2           0x82
#define LUX_DSP_COMMAND_PCM             0x83

#define LUX_DSP_COMMAND_PLAY            0x84
#define LUX_DSP_COMMAND_STOPF           0x85
#define LUX_DSP_COMMAND_PAUSE           0x86
#define LUX_DSP_COMMAND_MUTE            0x87
#define LUX_DSP_COMMAND_UNMUTE          0x88
#define LUX_DSP_COMMAND_CONFIG          0x89
#define LUX_DSP_COMMAND_VER             0x8a
#define LUX_DSP_COMMAND_STATUS          0x8b

#define LUX_DSP_COMMAND_VOLUME          0x8c
#define LUX_DSP_COMMAND_INITDONE        0x8d

#define LUX_DSP_COMMAND_FRAME           0xa0
#define LUX_DSP_COMMAND_CLRAUTH         0xa1
#define LUX_DSP_COMMAND_DECAUTH         0xa2
#define LUX_DSP_COMMAND_DRVAUTH         0xa3
#define LUX_DSP_COMMAND_KEYSHARE        0xa4
#define LUX_DSP_COMMAND_DISCKEY         0xa5
#define LUX_DSP_COMMAND_TITLEKEY        0xa6


#define G_EN 0x60000
#define G_SC 0x200
#define G_SD 0x400

/* These addresses are always relative to LUX_DRAM_BASE, in words
**  if you want to put an address into a LS220 register,  leftshift it 2 bits
*/

#define VIDEO_FIFO			(0x1C8000  >> 2)
#define VIDEO_FIFO_LEN			0x20000

#define VIDEO_PTS_FIFO			(0x1C7A00  >> 2)
#define VIDEO_PTS_FIFO_LEN		0x600

#define DSP_FIFO			(0x1FC000 >> 2)
#define DSP_FIFO_LEN			0x2000
#define DSP_PTS_FIFO			(0x1ffa00 >> 2)
#define DSP_PTS_FIFO_LEN		0x400



/* Addresses on the I2C bus:
*/

#define IIC_EPROM			0xa0
#define IIC_BT864			0x8a
#define IIC_CS4952			0x80
#define IIC_HS8170			0x42
#define IIC_SAA7120			0x8c
#define IIC_AD7175			0xd4
#define IIC_AD7176			0x54

/* Locations in the iic EPROM:
*/
#define EPROM_REGION			0x4
#define EPROM_REGION_COUNT		0x5
#define EPROM_PARENTAL			0x6
#define EPROM_BOARDTYPE			0x7
#define EPROM_CLOCKTYPE			0x8
#define EPROM_I2S			0x9
#define EPROM_SPDIF_CH			0xa
#define EPROM_SPDIF_ONOFF		0xb
#define EPROM_TVOUT                     0xc
#define EPROM_LEFT_CH_POL		0xf


/* Audio formats
*/
#define LUX_FORMAT_AC3 0x80
#define LUX_FORMAT_MPG 0x81
#define LUX_FORMAT_PCM 0x83

#ifdef _KERNEL

#define dev2unit(devt) (minor(devt) & 0xff)

#define IIC_DELAY	DELAY(200)

/*
 * One of these per allocated device
 */

typedef struct {
#ifdef DEVFS
        static void *devfs_token;
#endif
	struct resource *res_mem, *res_irq;
	void *res_irqhandler;
	int	opens;
	volatile uint	*virbase;
	vm_offset_t physbase;
	device_t dev;

	int videotype;     /* type of video generator which the LS220 is connected to */

	uint video_pts;
	uint video_ptr;
	uint video_total_bytes,video_remainder;

	uint audio_pts;
	uint audio_pts_count;
	uint audio_fifo_offset;
	uint audio_fifo_len;
	uint audio_total_bytes;
	uint audio_need_spdif_init;
	uint audio_spdif_enable;

	char eprom[16];
	int epromvalid;    /* flag for if we've read the eprom yet  */

	unsigned char buffer[1*1024*1024];
	int bufferlen;     /* number of bytes in the buffer which are valid  */
	uint audio_pos,video_pos;
	int seqheader;
	int prefill;

	uint mpeg1;    /* we assume mpeg-2, but recognize if its mpeg-1...  */
} lux_softc;

#endif
#endif
