/*
 *	This code was written by Thomas Tkacik and contains
 *	 absolutely no code from Mark Holm's Mahjongg program.
 *
 *	Do with it as you wish.
 *
 *	The 3b1 version was hacked/ported to a tty5620 terminal by
 *	Tommy Johnson, most of the 3b1 code was just commented out.
 *	Neither Mark Holm, or Thomas Tkacik know anything about this
 *	5620 version.
 *
 */

/* 3b1 files:
 #include <stdio.h>
 #include <fcntl.h>
 #include <termio.h>
 #include <sys/signal.h>
 #include <tam.h>
 #include <sys/font.h>
 #include "mahjongg.h"
*/

#include<dmd.h>
#include<dmdio.h>
#include<font.h>

#define  SIDEBORDER 6
#define  TOPBORDER  4

int (*signal())();

/* window discriptor */
int wn;

/* window width and height */
int win_width, win_height;

/* 3b1 stuff:
struct icon stick = {
	0,
	{ 16, 11, -8, -5, 0, 0, 0 },
	{ 0xfc00, 0x8200, 0x9980, 0x8040, 0x4120, 0x37d8,
	  0x0904, 0x0402, 0x0332, 0x0082, 0x007e }
};

struct umdata mouse = { MSDOWN, SIDEBORDER, TOPBORDER, 0, 0, &stick };

*/

int reborder(), leave();

/*  window routines */

/*
 * initialize window and draw initial borders
 */

initwindow()
{
#ifdef zero
	/* old 3b1 code:
     /* start with a clean window */
     /*  this needs to be done because winit() uses the */
     /*  current window first, so we open a new one     */

	(void)close(0);
	(void)close(1);
	(void)close(2);
	wn = open("/dev/window", O_RDWR );
	(void)dup(wn);
	(void)dup(wn);


     /* initialize the tam routines */
	winit();

     /* can only be run on the unixpc screen */
	if(iswind()==0) {
		(void)fprintf(stderr, "must use bitmapped screen\n");
		wexit(1);
	}
     /* open the mahjongg window */
	if((wn = wcreate(WINDOW_Y, WINDOW_X, ROWS, COLS, NBORDER)) == -1) {
		(void)fprintf(stderr, "could not open window  wn = %d\n",wn);
		wexit(1);
	}
#endif
	/* commented out code ends here ************************ */

     /* draw the initial border around the playing region */
	initborder();

     /* draw line separating playing area and text area */
/*   old 3b1 code:
	wrastop(wn, 0, 0, 0, 0, 0, 0, 0, 28,
		win_width, 1, SRCPAT, DSTSRC, patwhite);
*/
#ifdef zero
     /* set up function keys */
	wslk(wn, 0, "   HELP    SAME      NEW         UNDO     QUIT",
		    "           BOARD    BOARD");
	wuser(wn, "mahjongg");

     /* allow mouse inputs in 8 bit mode */
	keypad(0,1);

     /* turn off the cursor */
	wputs(wn,"\033[=1C");
	wgoto(wn, 1, 4);
	wputs(wn, "MAHJONGG");

     /* catch the signals */
	(void)signal(SIGHUP,  leave);
	(void)signal(SIGINT,  leave);
	(void)signal(SIGQUIT, leave);
	(void)signal(SIGWIND, reborder);
#endif
}

/*
 * draw the initial border around the playing window
 */

initborder()
{
#ifdef zero
	struct uwdata win;
     /* determine the initial window size in pixels */
	(void)ioctl(wn, WIOCGETD, &win);

     /* save the size so that everyone can use it */
/* 3b1 code:
	win_width  = win.uw_width;
	win_height = win.uw_height;
*/
#endif
	win_width=Drect.corner.x-Drect.origin.x;
	win_height=Drect.corner.y-Drect.origin.y;

     /* draw the border in the screen image */ 
/* 3b1 code:
	wrastop(wn, 0, 0, 0, 0, 0, 0, 0, 0,
		win_width, TOPBORDER, SRCPAT, DSTSRC, patwhite);
	wrastop(wn, 0, 0, 0, 0, 0, 0, 0, win_height-TOPBORDER,
		win_width, TOPBORDER, SRCPAT, DSTSRC, patwhite);
	wrastop(wn, 0, 0, 0, 0, 0, 0, 0, 0,
		SIDEBORDER, win_height, SRCPAT, DSTSRC, patwhite);
	wrastop(wn, 0, 0, 0, 0, 0, 0, win_width-SIDEBORDER, 0,
		SIDEBORDER, win_height, SRCPAT, DSTSRC, patwhite);
*/
}

/*
 * catch SIGWIND -- draw border as forground or background
 */

reborder()
{
#ifdef zero
	unsigned short *pat;
	struct uwdata win;

     /* determine if the window is on top */
	(void)ioctl(wn, WIOCGETD, &win);

     /* if current window then add border interior  else remove it */
	pat = (win.uw_uflags & KBDWIN) ? patwhite : patblack;

	wrastop(wn, 0, 0, 0, 0, 0, 0, 1, 1,
		win_width-2, TOPBORDER-2, SRCPAT, DSTSRC, pat);
	wrastop(wn, 0, 0, 0, 0, 0, 0, 1, win_height-TOPBORDER+1,
		win_width-2, TOPBORDER-2, SRCPAT, DSTSRC, pat);
	wrastop(wn, 0, 0, 0, 0, 0, 0, 1, 1,
		SIDEBORDER-2, win_height-2, SRCPAT, DSTSRC, pat);
	wrastop(wn, 0, 0, 0, 0, 0, 0, win_width-SIDEBORDER+1, 1,
		SIDEBORDER-2, win_height-2, SRCPAT, DSTSRC, pat);

     /* reset signal trap */
	(void) signal(SIGWIND, reborder);
#endif
}

/*
 * initialize the mouse to send mouse reports
 */
#ifdef zero
initmouse()
{
	mouse.um_w = win_width-SIDEBORDER-1;
	mouse.um_h = win_height-TOPBORDER-1;

	wsetmouse(wn, &mouse);
}
#endif

/*
 * SIGINT, SIGQUIT -- close windows and cleanup
 */

leave()
{
/* old 3b1 code:
	wdelete(wn);
	wexit(0);
*/
	exit();
}

/* REPLACEMENT: a wcmd work-a-like for 5620  (I think)
*/
wcmd(fn,s)
int fn;
char *s;
{
	rectf(&display,Rect(Drect.origin.x+4,Drect.corner.y-15,Drect.corner.x,Drect.corner.y),F_CLR);
	string(&defont,s,&display,Pt(Drect.origin.x+8,Drect.corner.y-15),F_STORE);
}
