/*
 *	This program contains much of the code from the original
 *	 Sun version of mahjongg, written by Mark Holm, which was
 *	 inspired by the PC version.
 *
 *	This version of Mahjongg was modified/re-written/ported
 *	 for/to the AT&T UNIXPC    by Thomas Tkacik
 *                                 ...rphroy!tetnix!tet.
 *
 *	Any problems or comments should be addressed to Tom Tkacik
 *	 and not Mark Holm, who had nothing to do with this version
 *	 and will not be able to help you.
 *
 *	The 3b1 version was hacked/ported to a tty5620 terminal by
 *	Tommy Johnson, most of the 3b1 code was just commented out.
 *	Neither Mark Holm, or Thomas Tkacik know anything about this
 *	5620 version
 *
 */

/*
 *	Copyright 1988, Mark Holm
 *			Exceptions
 *
 *	Permission is given to copy and distribute for non-profit purposes.
 *
 */
/* 3b1 include files   NA on a 5620
 #include <stdio.h>
 #include <fcntl.h>
 #include <termio.h>

#include <sys/signal.h>
#include <tam.h>
#include <sys/font.h>
#include <sys/mouse.h>
*/
#include<dmd.h>
#include<dmdio.h>
#include<font.h>
#include "mahjongg.h"

/*   Don't exist on a 5620
long time();
long atol();
void exit();
*/

#define wn 0    /* an argument on a 3b1 which is also meaningless on a 5620 */

/* number used to generate the current board */
long board;

main(argc, argv)
int argc;
char *argv[];
{
	int c, errflg = 0;
	int i,j,k;
	Word t;
	extern int optind;
	extern char *optarg;

	initrandom();

     /* parse arguments --  -n # is the only allowed argument */

/*   FIXME
	while((c = getopt(argc, argv, "n:")) != EOF) {
		switch(c) {
			case 'n':
				board = atol(optarg);
				srand(board);
				break;
			default:
				errflg = 1;
		}
	}
*/

	if (strcmp(argv[1],"-n")==0)
		board=atoi(argv[2]);

	if(errflg == 1) {
		fprintf(stderr, "Usage: mahjongg [-n #]\n");
		exit();
	}
			

	initwindow();

/* NA on a 5620
	initmouse();
*/

	start_game();
	wcmd(wn, "starting new game");

	dispatch();

	leave();
}

/*
 * get an initial random number from the process id
 */
/* THIS WAS EDITED for 5620 */
initrandom()
{
	srand(realtime());

     /* let board be the first number in the random sequence */
     /*  this will vary more than (getpid+time) does */

	board = (rand());
	srand(board);
}

/*
** read input and call appropriate routines
*/
#ifdef zero
dispatch()
{
	int c;

	for(;;) {
		c = wgetc(wn);
		switch(c) {
			case F1:
				help();
				break;
			case F2:
				start_game();
				break;
			case F3:
				new();
				break;
			case F4:
				undo_proc();
				break;
			case F5:
				quit();
				return;
				break;
			case Mouse:
				domouse();
				break;
			default:
			     /* ignore all other input */
				break;
		}
	}
}
#endif
/* dispach - the 5620 version 
*/
dispatch()
{
	int c;
	request(MOUSE|KBD|RESHAPED);
	P->state |=NOPFEXPAND;
	for(;;)
	{
		wait(MOUSE|KBD|RESHAPED);
		if (own()&MOUSE)
		{
			if (button3() && (!help_mode) && (selected[0]==-1))   /* pop up 5620 menu if */
			{                                /* we don't need the   */
				request(KBD|RESHAPED);   /* 3rd button          */
				sleep(2);
				request(MOUSE|KBD|RESHAPED);
			}
			domouse();
			while(mouse.buttons&0x7)
				sleep(2);
		}
		if (own()&KBD)
		{
			switch(c=kbdchar())
			{
			case 0x82:
				help();
				break;
			case 0x83:
				start_game();
				break;
			case 0x84:
				new();
				break;
			case 0x85:
				undo_proc();
				break;
			case 0x86:
				quit();
				return;
				break;
			}
		}
		if (P->state&RESHAPED)
		{
			draw_tiles();
			P->state&=~RESHAPED;
		}
	}
}

/*
 * start a new game
 */

new()
{
     /* use only the high 16 significant bits of board */

	board = (rand());   /* except that rand is only 16 bits */

	start_game();

	wcmd(wn, "starting new game");
}

/*
 * play the game with the current board number
 */

start_game()
{
	srand(board);

	tile_count = 144;

     /* set the tiles up for randomizing */

	initmahjongg();

	draw_tiles();

	wcmd(wn, "replaying same game");
/*
	wprompt(wn, "");
*/
}

/*
 * when the help button is pushed
 */

help()
{
	if((selected[0] != -1) && !help_mode) {

	     /* in query mode */

		help_proc();
	} else {

	     /* not in query mode */

		query_mode = FALSE;

	     /* cancel preview of selected tiles */
	 
		preview_tile(selected[0]);
		preview_tile(selected[1]);

	     /* Clean up selected's variables */

		selected[0] = -1;
		selected[1] = -1;

	     /* do next help */

		help_proc();
	}
}

/*
 * when the quit button is pushed
 */

quit()
{
	wcmd(wn, "quit");
/*   NA on a 5620
	wprompt(wn, " ");
*/
	exit();
}

/*
 * when one of the mouse buttons is pushed
 */

domouse()
{
	int i;
	int x, y, buttons, reason;

	x=mouse.xy.x-Drect.origin.x;
	y=mouse.xy.y-Drect.origin.y;
	buttons=mouse.buttons;

/* OLD 3b1 command:
	wreadmouse(wn, &x, &y, &buttons, &reason);
*/

     /* see if the mouse is in a free tile */

	for(i = NUMTILES-1; i >= 0; i--) {
	    	if((x >= tiles[i].x_pos) &&
		   (x <  tiles[i].x_pos + TILE_X) &&
		   (y >= tiles[i].y_pos) &&
		   (y <  tiles[i].y_pos + TILE_Y) &&
		   (tiles[i].removed == FALSE) &&
		   (tiles[i].top_free == TRUE) &&
		   ((tiles[i].left_free == TRUE) ||
		    (tiles[i].right_free == TRUE))) {
			break;
		}
	}

    /* i will equal -1 if not on a legal tile */
	play_event_proc(i, buttons);
}

/*
 * initialize the mahjongg tiles
 */

initmahjongg()
{
	int i, j;

	selected[0] = -1;
	selected[1] = -1;
	undo_count  = -1;

	wcmd(wn,"Building board. Please Wait.");

     /* set up tiles for shuffling */

	for(i = 0, j = 0; i < 34; i+=1, j+=4) {
		tiles[j].value = i;
		tiles[j].image = images[i];
		tiles[j+1].value = i;
		tiles[j+1].image = images[i];
		tiles[j+2].value = i;
		tiles[j+2].image = images[i];
		tiles[j+3].value = i;
		tiles[j+3].image = images[i];
	}

     /* now the one of a kind tiles */

	for(i = 34, j = 136; i < 36; i+=1, j+=4) {
		tiles[j].value = i;
		tiles[j].image = images[j-136+34];
		tiles[j+1].value = i;
		tiles[j+1].image = images[j-136+34 + 1];
		tiles[j+2].value = i;
		tiles[j+2].image = images[j-136+34 + 2];
		tiles[j+3].value = i;
		tiles[j+3].image = images[j-136+34 + 3];
	}

     /* shuffle tiles */

	for(i = NUMTILES-1; i > 0 ; i--) {
		Tile temp;

	     /* a random integer between 0 and i */

		j = muldiv(rand(),i,0xFFFF);

	     /* swap tiles */

		temp = tiles[i];
		tiles[i] = tiles[j];
		tiles[j] = temp;
	}

	position_tiles();
}

/*
 * give each tile a position on the playing board 
 */

position_tiles()
{
	int i, j;
	int x_pos, y_pos;

     /* give each tile a position on the board */

     /* ROW 1 */
	x_pos = X_OFF2;
	y_pos = Y_OFF1;
	for(i = 0; i < 12; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[0].left_free = TRUE;
	tiles[0].left_next[0] = -1;
	tiles[11].right_free = TRUE;
	tiles[11].right_next[0] = -1;

     /* ROW 2 */
	x_pos = X_OFF4;
	y_pos = Y_OFF2;
	for(i = 12; i < 20; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[12].left_free = TRUE;
	tiles[12].left_next[0] = -1;
	tiles[19].right_free = TRUE;
	tiles[19].right_next[0] = -1;

     /* ROW 3 */
	x_pos = X_OFF3;
	y_pos = Y_OFF3;
	for(i = 20; i < 30; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[20].left_free = TRUE;
	tiles[20].left_next[0] = -1;
	tiles[29].right_free = TRUE;
	tiles[29].right_next[0] = -1;

     /* ROW 4 1/2  Left side */
	x_pos = X_OFF1;
	y_pos = Y_OFF45;
	init_tile(30, x_pos, y_pos);
	tiles[30].left_free = TRUE;
	tiles[30].left_next[0] = -1;
	tiles[30].right_next[1] = 43;

     /* ROW 4 */
	x_pos = X_OFF2;
	y_pos = Y_OFF4;
	for(i = 31; i < 43; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[42].right_next[0] = 55;

     /* ROW 5 */
	x_pos = X_OFF2;
	y_pos = Y_OFF5;
	for(i = 43; i < 55; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[43].left_next[0] = 30;

     /* ROW 4 1/2  Right side */
	x_pos = X_OFF14;
	y_pos = Y_OFF45;
	for(i = 55; i < 57; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[55].left_next[1] = 42;
	tiles[56].right_free = TRUE;
	tiles[56].right_next[0] = -1;

     /* ROW 6 */
	x_pos = X_OFF3;
	y_pos = Y_OFF6;
	for(i = 57; i < 67; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[57].left_free = TRUE;
	tiles[57].left_next[0] = -1;
	tiles[66].right_free = TRUE;
	tiles[66].right_next[0] = -1;

     /* ROW 7 */
	x_pos = X_OFF4;
	y_pos = Y_OFF7;
	for(i = 67; i < 75; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[67].left_free = TRUE;
	tiles[67].left_next[0] = -1;
	tiles[74].right_free = TRUE;
	tiles[74].right_next[0] = -1;

     /* ROW 8 */
	x_pos = X_OFF2;
	y_pos = Y_OFF8;
	for(i = 75; i < 87; i++) {
		init_tile(i, x_pos, y_pos);
		x_pos += TILE_X;
	}
	tiles[75].left_free = TRUE;
	tiles[75].left_next[0] = -1;
	tiles[86].right_free = TRUE;
	tiles[86].right_next[0] = -1;

     /* LEVEL 2 */
	x_pos = X_OFF5 + X_OFFL2;
	y_pos = Y_OFF2 + Y_OFFL2;
	for(i = 87; i < 123; i+=6) {
		for(j = 0; j < 6; j++) {
			init_tile(i+j, x_pos, y_pos);
			x_pos += TILE_X;
		}
		x_pos = X_OFF5 + X_OFFL2;
		y_pos += TILE_Y;
		tiles[i].left_free = TRUE;
		tiles[i].left_next[0] = -1;
		tiles[i+5].right_free = TRUE;
		tiles[i+5].right_next[0] = -1;
	}

     /* LEVEL 3 */
	x_pos = X_OFF6 + X_OFFL3;
	y_pos = Y_OFF3 + Y_OFFL3;
	for(i = 123; i < 139; i+=4) {
		for(j = 0; j < 4; j++) {
			init_tile(i+j, x_pos, y_pos);
			x_pos += TILE_X;
		}
		x_pos = X_OFF6 + X_OFFL3;
		y_pos += TILE_Y;
		tiles[i].left_free = TRUE;
		tiles[i].left_next[0] = -1;
		tiles[i+3].right_free = TRUE;
		tiles[i+3].right_next[0] = -1;
	}

     /* LEVEL 4 */
	x_pos = X_OFF7 + X_OFFL4;
	y_pos = Y_OFF4 + Y_OFFL4;
	for(i = 139; i < 143; i+=2) {
		for(j = 0; j < 2; j++) {
			init_tile(i+j, x_pos, y_pos);
			x_pos += TILE_X;
		}
		x_pos = X_OFF7 + X_OFFL4;
		y_pos += TILE_Y;
		tiles[i].left_free = TRUE;
		tiles[i].left_next[0] = -1;
		tiles[i+1].right_free = TRUE;
		tiles[i+1].right_next[0] = -1;
	}
	tiles[139].top_free = FALSE;
	tiles[140].top_free = FALSE;
	tiles[141].top_free = FALSE;
	tiles[142].top_free = FALSE;

     /* LEVEL 5 */
	x_pos = X_OFF75 + X_OFFL5;
	y_pos = Y_OFF45 + Y_OFFL5;
	init_tile(143, x_pos, y_pos);
	tiles[143].left_free = TRUE;
	tiles[143].left_next[0] = -1;
	tiles[143].right_free = TRUE;
	tiles[143].right_next[0] = -1;
	tiles[143].covered[0] = 139;
	tiles[143].covered[1] = 140;
	tiles[143].covered[2] = 141;
	tiles[143].covered[3] = 142;

     /* this code copied verbatim from Mark Holm's Mahjongg */
     /* set top_free flags  and covered pointers */

	for(i = 87, j = 13; i < 143; i++, j++) {
		tiles[i].covered[0] = j;
		tiles[j].top_free = FALSE;
		switch(j) {
			case 97:
			case 103:
			case 109:
			case 129:
				 j += 2;
				 break;
			case 18:
			case 64:
				 j += 3;
				 break;
			case 27:
			case 39:
				 j += 6;
				 break;
			case 51:
				 j += 7;
				 break;
			case 73:
				 j += 20;
				 break;
			case 115:
				 j += 12;
				 break;
		}
	}
}

/*
 * give tile i its default initial values
 */

init_tile(i, x_pos, y_pos)
int i;
int x_pos, y_pos;
{
	tiles[i].x_pos = x_pos;
	tiles[i].y_pos = y_pos;
	tiles[i].left_free = FALSE;
	tiles[i].right_free = FALSE;
	tiles[i].top_free = TRUE;
	tiles[i].left_next[0] = i - 1;
	tiles[i].left_next[1] = -1;
	tiles[i].right_next[0] = i + 1;
	tiles[i].right_next[1] = -1;
	tiles[i].covered[0] = -1;
	tiles[i].covered[1] = -1;
	tiles[i].covered[2] = -1;
	tiles[i].covered[3] = -1;
	tiles[i].removed = FALSE;
}

wstringxy(p,s)
Point p;
char *s;
{
	string(&defont,s,&display,Pt(Drect.origin.x+(p.y*14),Drect.origin.y+(p.x*14)),F_STORE);
}

/*
 * draw the tiles on the playing field
 */

draw_tiles()
{
	int i = 0;
	Rectangle rec;
	Bitmap btil;
	char s[40];

	btil.width=(short)2;
	btil.rect=Rect(0,0,48,32);
	btil._null=NULL;

/*   old 3b1 code:
	wgoto(wn, 1, 23);
	wprintf(wn, "Tiles Remaining: %3d", tile_count);
	wgoto(wn, 1, 53);
	wprintf(wn, "Board Number: %5ld", board);
*/
	sprintf(s,"Tiles Remaining: %d",tile_count);
	wstringxy(Pt(1,7),s);
	sprintf(s,"Board Number: %d", board);
	wstringxy(Pt(1,23),s);
	wstringxy(Pt(21,1),"F1 - Help         F4 - Undo");
	wstringxy(Pt(22,1),"F2 - Start over   F5 - Quit");
	wstringxy(Pt(23,1),"F3 - New Game");

     /* clear the playing field */
/* OLD 3b1 code:
	wrastop(wn, 0, 0, 0, 0, 0, 0,
		X_OFF1, Y_OFF1, 14*TILE_X+TILE_W, 7*TILE_Y+TILE_H,
		SRCPAT, DSTSRC, patblack);
*/
	rec.origin.x=X_OFF1+Drect.origin.x;
	rec.origin.y=Y_OFF1+Drect.origin.y;
	rec.corner.x=X_OFF1+14*TILE_X+TILE_W+Drect.origin.x;
	rec.corner.y=Y_OFF1+7*TILE_Y+TILE_H+Drect.origin.y;
	rectf(&display,rec,F_CLR);

     /* place tiles */

	for(i = 0; i < NUMTILES; i++) {
		if(tiles[i].removed == TRUE)
			continue;
		
		if((i >= 139) || (tiles[i].top_free == TRUE)) {

		     /* show the tile */

			btil.base=tiles[i].image;
			bitblt(&btil,Rect(0,0,48,32),&display,Pt(Drect.origin.x+tiles[i].x_pos,Drect.origin.y+tiles[i].y_pos),F_STORE);

/* old 3b1 code:
			wrastop(wn, tiles[i].image, 6, 0, 0, 0, 0,
				tiles[i].x_pos, tiles[i].y_pos, 
				TILE_W, TILE_H, SRCSRC, DSTSRC, 0); 
*/
		} else {

		     /* draw a blank tile -- do not show hidden tiles */
			btil.base=(Word*)blank;
			bitblt(&btil,Rect(0,0,48,32),&display,Pt(Drect.origin.x+tiles[i].x_pos,Drect.origin.y+tiles[i].y_pos),F_STORE);

/* old 3b1 code:
			wrastop(wn, blank, 6, 0, 0, 0, 0,
				tiles[i].x_pos, tiles[i].y_pos, 
				TILE_W, TILE_H, SRCSRC, DSTSRC, 0);
*/
		}
	}
}

/*
 * highlight a tile -- if already highlighted, turn it off
 */

preview_tile(i)
int i;
{
/*  OLD 3b1 code, replaced with 5620 code
	wrastop(wn, 0, 0, 0, 0, 0, 0,
		tiles[i].x_pos+1, tiles[i].y_pos+1,
		TILE_X-1, TILE_Y-1, SRCPAT, DSTXOR, patwhite);
*/
	Rectangle rec;
	rec.origin.x=tiles[i].x_pos+1+Drect.origin.x;
	rec.origin.y=tiles[i].y_pos+1+Drect.origin.y;
	rec.corner.x=rec.origin.x+TILE_X-1;
	rec.corner.y=rec.origin.y+TILE_Y-1;
	rectf(&display,rec,F_XOR);
}

/*
 * beep at the user
 */

window_bell()
{
/* OLD 3b1 code:
	wprintf(wn, "\007");
*/
	ringbell();
}

