#include <stdio.h>

#include "ppm.h"


int main(int argc, char *argv[])
{
	int infd;
	unsigned char header[8];
	int w,h;
	unsigned char buff[1024*16];
	int rc;
	Image *img;

	if (argc==1)
		img=imageReadFD(stdin,NULL);
	else
		img=imageRead(argv[1],NULL);

	if (img==NULL)
		return -1;

	fprintf(stderr,"dimension %d,%d\n",img->width, img->height);
	w=img->width+1;
	h=img->height+1;

	header[0]=0;
	header[1]=1;
	header[2]=0;
	header[3]=1;
	header[4]=w>>8;
	header[5]=w;
	header[6]=h>>8;
	header[7]=h;

	write(1,header,sizeof(header));
	write(1, img->data,w*h/8);

}
