/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
static char ID[] = "@(#) sgetl.c: 1.1 1/8/82";
/*
 * The intent here is to provide a means to make the value of
 * bytes in an io-buffer correspond to the value of a long
 * in the memory while doing the io a `long' at a time.
 * Files written and read in this way are machine-independent.
 *
 */
#include <values.h>
#include <sys/types.h>

int32_t
sgetl(char *buffer)
{
	register int32_t w = 0;
	register int i = BITSPERBYTE * sizeof(int32_t);

	while ((i -= BITSPERBYTE) >= 0)
		w |= (int32_t) ((unsigned char) *buffer++) << i;
	return (w);
}
