/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>
#include "filehdr.h"
#include "syms.h"
#include "ldfcn.h"

char *
ldgetname(LDFILE *ldptr, SYMENT *symentry)
{
	static char buffer[BUFSIZ + SYMNMLEN];
//	extern int vldldptr();
#ifdef FLEXNAMES
	static char *strtab = NULL;
	static int last_fnum_ = 0;
	static int32_t last_offset = -1L;
	static int32_t length;
#endif

	if (vldldptr(ldptr) != SUCCESS)
		return (NULL);
#ifdef FLEXNAMES
	if (symentry->n_zeroes == 0L)	/* stored in string table */
	{
		/*
		* Different archive members are noted by the OFFSET change.
		* Otherwise, normal other ldptr's are distinguished by
		* the different _fnum_'s.
		*/
		if (last_offset != OFFSET(ldptr) ||
			last_fnum_ != ldptr->_fnum_)
		{
			int32_t string_begin, home;

			if (strtab != NULL)
				free(strtab);
			string_begin = HEADER(ldptr).f_symptr +
				HEADER(ldptr).f_nsyms * SYMESZ;
			home = FTELL(ldptr);
			if (FSEEK(ldptr, string_begin, BEGINNING) == -1 ||
				DMDFREAD((char *)&length, sizeof(int32_t), 1, ldptr)
				!= 1 ||
				(strtab = malloc((unsigned)length)) == NULL ||
				DMDFREAD(strtab + sizeof(int32_t), sizeof(char),
				length - sizeof(int32_t), ldptr)
				!= length - sizeof(int32_t) ||
				fseek(IOPTR(ldptr), home, 0) == -1 ||
				strtab[length - 1] != '\0')
			{
				/*
				* Try to have no side effects if an error
				* occurs somewhere...
				*/
				(void)fseek(IOPTR(ldptr), home, 0);
				return (NULL);
			}
			last_fnum_ = ldptr->_fnum_;
			last_offset = OFFSET(ldptr);
		}
		if (length <= symentry->n_offset)
			return (NULL);
		return (strcpy(buffer, strtab + symentry->n_offset));
	}
	else	/* still in old COFF location */
#endif
	{
		(void)strncpy(buffer, symentry->n_name, SYMNMLEN);
		buffer[SYMNMLEN] = '\0';
		return (buffer);
	}
}

static char ID[] = "@(#) ldgetname.c: 1.2 2/16/83";
