/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
static char ID[] = "@(#) instr.c: 1.2 2/27/84";

/*
 * Define various statistic-collection variables used to monitor the
 * internal workings of ld
 *
 *
 * Statistics are collected if the compile time define PERF_DATA
 * is turned on.  Output of these variables
 * is controlled by the presence of the UN*X file "instr.data". If
 * this file exists and can be opened for "append", these variables
 * are output.  Output occurs only on complete, successful of ld.
 *
 * In addition, there is the debug flag, "-dn", which 
 * controls the output of intermediate information to stderr during
 * the ld run.  WARNING, the link editor has not been compiled
 * with DEBUG on lately so none of that code is guarrenteed
 * to work.
 *
 * A SDP profile is generated by using the dflag values of:
 *
 *	>10 :	output to stderr information on calls to the SDP
 *		function repartition()
 *
 *	>12 :	output to stderr additional information on calls
 *		to the SDP function repartition()
 *
 *	>15 :	output to stderr information on calls to the SDP
 *		functions allocate, lock, and unlock. In addition,
 *		indicate when all SDP I/O occurres
 */

#if PERF_DATA
int32_t	SDP_read = 0L,		/* calls to read() from within SDP  */
	SDP_write = 0L,		/* calls to write() from within SDP */
	LD_lock = 0L,		/* calls to lock() from within LD   */
	LD_unlock = 0L;		/* calls to unlock() from within LD */

int32_t	nwalks = 0L,		/* number of collision chain walks  */
	nfwalks = 0L,		/* number of unsuccessful walks	    */
	ncolisns = 0L,		/* number of hashtab[] collisions   */
	maxchain = 0L;		/* max length of a collision chain  */

int32_t	ttime;			/* total elapsed time		    */
struct tbuffer {		/* process and child execution	    */
	int32_t proc_user_time;	/*	times, as returned by the   */
	int32_t proc_system_time;	/*	times() function	    */
	int32_t child_user_time;
	int32_t child_system_time;
	} ptimes;
#endif
