/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
/*
 * static char ID_symsh[] = "@(#) syms.h: 1.5 2/24/83";
 */

#ifndef DMD_SYMS_H
#define DMD_SYMS_H

/*		Storage Classes are defined in storclass.h  */
#include "storclass.h"

/*		Number of characters in a symbol name */
#define  SYMNMLEN	8
/*		Number of characters in a file name */
#define  FILNMLEN	14
/*		Number of array dimensions in auxiliary entry */
#define  DIMNUM		4

// TOJ: this struct must be 18 bytes long.
struct __attribute__((packed)) syment
{
	union
	{
		char		_n_name[SYMNMLEN];	/* old COFF version */			// 8
		struct __attribute__((packed))
		{
			int32_t	_n_zeroes;	/* new == 0 */					// 4
			int32_t	_n_offset;	/* offset into string table */			// 4
		} _n_n;										// 8
//		char		*_n_nptr[2];	/* allows for overlaying */
// on a 64 bit machine, this var is too long, and screws up loading the file
		char		*_n_nptr[1];	/* allows for overlaying */			// 8
	} _n;
	int32_t			n_value;	/* value of symbol */				// 4
	short			n_scnum;	/* section number */				// 2
	unsigned short		n_type;		/* type and derived type */			// 2
	char			n_sclass;	/* storage class */				// 1
	char			n_numaux;	/* number of aux. entries */			// 1
};

#define n_name		_n._n_name
// TOJ: n_nptr is stuffed into the second element...  so n_zero would be preserved...  except that
// 64 bit pointers don't fit...  Moving it to the 0'th element to see what happens
//#define n_nptr		_n._n_nptr[1]
#define n_nptr		_n._n_nptr[0]
#define n_zeroes	_n._n_n._n_zeroes
#define n_offset	_n._n_n._n_offset

/*
   Relocatable symbols have a section number of the
   section in which they are defined.  Otherwise, section
   numbers have the following meanings:
*/
        /* undefined symbol */
#define  N_UNDEF	0
        /* value of symbol is absolute */
#define  N_ABS		-1
        /* special debugging symbol -- value of symbol is meaningless */
#define  N_DEBUG	-2
	/* indicates symbol needs transfer vector (preload) */
#define  N_TV		(unsigned short)-3

	/* indicates symbol needs transfer vector (postload) */

#define  P_TV		(unsigned short)-4

/*
   The fundamental type of a symbol packed into the low 
   4 bits of the word.
*/

#define  _EF	".ef"

#define  T_NULL     0
#define  T_ARG      1          /* function argument (only used by compiler) */
#define  T_CHAR     2          /* character */
#define  T_SHORT    3          /* short integer */
#define  T_INT      4          /* integer */
#define  T_LONG     5          /* long integer */
#define  T_FLOAT    6          /* floating point */
#define  T_DOUBLE   7          /* double word */
#define  T_STRUCT   8          /* structure  */
#define  T_UNION    9          /* union  */
#define  T_ENUM     10         /* enumeration  */
#define  T_MOE      11         /* member of enumeration */
#define  T_UCHAR    12         /* unsigned character */
#define  T_USHORT   13         /* unsigned short */
#define  T_UINT     14         /* unsigned integer */
#define  T_ULONG    15         /* unsigned long */

/*
 * derived types are:
 */

#define  DT_NON      0          /* no derived type */
#define  DT_PTR      1          /* pointer */
#define  DT_FCN      2          /* function */
#define  DT_ARY      3          /* array */

/*
 *   type packing constants
 */

#define  N_BTMASK     017
#define  N_TMASK      060
#define  N_TMASK1     0300
#define  N_TMASK2     0360
#define  N_BTSHFT     4
#define  N_TSHIFT     2

/*
 *   MACROS
 */

	/*   Basic Type of  x   */

#define  BTYPE(x)  ((x) & N_BTMASK)

	/*   Is  x  a  pointer ?   */

#define  ISPTR(x)  (((x) & N_TMASK) == (DT_PTR << N_BTSHFT))

	/*   Is  x  a  function ?  */

#define  ISFCN(x)  (((x) & N_TMASK) == (DT_FCN << N_BTSHFT))

	/*   Is  x  an  array ?   */

#define  ISARY(x)  (((x) & N_TMASK) == (DT_ARY << N_BTSHFT))

	/* Is x a structure, union, or enumeration TAG? */

#define ISTAG(x)  ((x)==C_STRTAG || (x)==C_UNTAG || (x)==C_ENTAG)

#define  INCREF(x) ((((x)&~N_BTMASK)<<N_TSHIFT)|(DT_PTR<<N_BTSHFT)|(x&N_BTMASK))

#define  DECREF(x) ((((x)>>N_TSHIFT)&~N_BTMASK)|((x)&N_BTMASK))

/*
 *	AUXILIARY ENTRY FORMAT
 */

// TOJ: this struct is supposed to be 18 bytes long...  but its 20  (this seems to be fixed)
union __attribute__((packed)) auxent
{
	struct __attribute__((packed))
	{
		int32_t		x_tagndx;	/* str, un, or enum tag indx */			// 4
		union
		{
			struct __attribute__((packed))
			{
				unsigned short	x_lnno;	/* declaration line number */		// 2
				unsigned short	x_size;	/* str, union, array size */		// 2
			} x_lnsz;
			int32_t	x_fsize;	/* size of function */				// 4
		} x_misc;									// =4  (and is 4)
		union
		{
			struct	__attribute__((packed))		/* if ISFCN, tag, or .bb */
			{
				int32_t	x_lnnoptr;	/* ptr to fcn line # */			// 4
				int32_t	x_endndx;	/* entry ndx past block end */		// 4
			} 	x_fcn;
			struct	__attribute__((packed))		/* if ISARY, up to 4 dimen. */
			{
				unsigned short	x_dimen[DIMNUM];				// 2 * DIMNUM = 8
			} 	x_ary;
		}		x_fcnary;							//= 8  (and is 8)
		unsigned short  x_tvndx;		/* tv index */				// 2
	} 	x_sym;										//  (but should be 18)
	struct __attribute__((packed))
	{
		char	x_fname[FILNMLEN];							// 14
	} 	x_file;										// =14
        struct __attribute__((packed))
        {
                int32_t    x_scnlen;          /* section length */				// 4
                unsigned short  x_nreloc;  /* number of relocation entries */			// 2
                unsigned short  x_nlinno;  /* number of line numbers */				// 2
        }       x_scn;										// =8

	struct __attribute__((packed))
	{
		int32_t		x_tvfill;	/* tv fill value */				// 4
		unsigned short	x_tvlen;	/* length of .tv */				// 2
		unsigned short	x_tvran[2];	/* tv range */					// 2 * 2=4
	}	x_tv;	/* info about .tv section (in auxent of symbol .tv)) */			// = 10 (but is 12)
};

#define	SYMENT	struct syment
#define	SYMESZ	18	/* sizeof(SYMENT) */

#define	AUXENT	union auxent
#define	AUXESZ	18	/* sizeof(AUXENT) */

/*	Defines for "special" symbols   */

#if VAX
#define _ETEXT	"_etext"
#define	_EDATA	"_edata"
#define	_END	"_end"
#else
#define _ETEXT	"etext"
#define _EDATA	"edata"
#define _END	"end"
#endif

#define _START	"_start"

#define _TVORIG	"_tvorig"
#define _TORIGIN	"_torigin"
#define _DORIGIN	"_dorigin"

#define _SORIGIN	"_sorigin"

#endif
