/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
/*
 * static char ID_wrtfrmc[] = "@(#) writeframe.c: 1.1 1/8/82";
 */

void writeframe(int framenbr)
{

	register int index;
	register HEADER *gframe;
	int byteswritten, spacenbr, fdes;
	char file_name[NAMELENG];
	int32_t offset;
	int32_t pagenbr;
	
	spacenbr = XTRCTSP(manager[framenbr].page_id);
	pagenbr  = XTRCTPN(manager[framenbr].page_id);
	
	gframe = &global_frames[spacenbr];
	
	offset = 0L;
	for( index = 0; index < gframe->numbfiles; index++ ) {
		if( pagenbr < (offset + gframe->filesize[index]) )
			break;
		offset += gframe->filesize[index];
		}
	if( index == gframe->numbfiles )
		if( gframe->numbfiles == MAXFILES )
			return( fatal("address space too large") );
		else
			gframe->filedes[++gframe->numbfiles] = NOTMADE;
	
	offset = pagenbr - offset;
	
	sprintf(file_name, "%s/%s%d", direct_names[spacenbr], TEMPLATE, index);
	
	if( gframe->filedes[index] == NOTMADE ) {
		if( (fdes = creat(file_name,MODE) ) < 0 )
			return( fatal("create of new SDP file failed") );
		if( close(fdes) == SYSERR )
			return( fatal("close of new SDP file failed") );
		gframe->filedes[index] = CLOSED;
		}

	if( gframe->filedes[index] == CLOSED )
		if( (gframe->filedes[index] = open(file_name, RW)) < 0 )
			return( fatal("open of new SDP file failed") );
	
	if( lseek(gframe->filedes[index], offset*PAGESIZE, 0) < 0 )
		return( fatal("lseek on SDP file failed") );
	
	SDP_write++;
	if( dflag > 15 )
		fprintf( stderr, " w%02d ", framenbr );

	if( (byteswritten =
		write(gframe->filedes[index], manager[framenbr].frame_pntr, PAGESIZE)) < 0 )
		return( fatal("write failed to SDP file") );
	
	partusage[manager[framenbr].partition]++;
	partusage[num_partitions]++;

	return( byteswritten );
}
