#include<stdio.h>
#include<stdlib.h>
#include<signal.h>
#include<strings.h>
#include<errno.h>
#include<unistd.h>
#include<sys/time.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<ctype.h>
#include"conf.h"

//#define  DEBUG 
/* max number of servers to support */
#define MAXSERVER 20
/* max number of log files */
#define MAXLOG 20
/* max number of child processes */
#define MAXKIDS 500

/* max url size, includes method and any args */
#define URLSIZE 2048
#define HOSTLEN 160

/*  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**  
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**  
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define TIMEVALTOFLOAT(x) ((float)x.tv_sec+(x.tv_usec/(float)1000000))

/* struct returned by client   */
typedef struct result_struct
{
int            sentb,recb;    /* bytes in query, bytes in response */
struct timeval connect,sentt,rect;  
} result;

struct url
{
  int port;
  char server[HOSTLEN];
  char url[URLSIZE];
};

struct url spliturl(char *url);

struct timeval timevaldiff(struct timeval a,struct timeval b)
{
	struct timeval tmp;
	tmp.tv_usec=a.tv_usec-b.tv_usec;
	if (tmp.tv_usec<0)
	{
		a.tv_sec--;
		tmp.tv_usec+=1000000;
	} 
	tmp.tv_sec=a.tv_sec-b.tv_sec;
	return tmp;
}

void makerandom(char *buff,int len);
int kid(int id, int urlpipe, int flowpipe,char *server[],int sport[],int numserver);
static int writen(int fil, char *buff,int len);

int maxpar;
int numserver;
int numlog;
int timeout;
int itimeout;
int reps;
int proxy;
char *server[MAXSERVER];
int port[MAXSERVER];
char *log[MAXLOG];
int interupted;

int killem;   /* flag set by sigint, causes lead webjamma process to kill */
	      /* all the kids and exit */

/*signal handlers: */

void sigalarm()
{
	fprintf(stderr,"%d: alarm!\n",getpid());
	interupted=1;
}

void sigint()
{
	killem=1;
}

/* this does the dirty work: grabs a page, and throws it away.  
** returns less than zero on error, size of the file on success 
*/
result clientget(char *server, int port, char *page)
{
	int fil,c;
	char buff[1024];
	int first=1;
	int size;
	struct timeval start,finish;
	struct timezone tz;
	result ans;
        ans.connect.tv_sec=0;
        ans.connect.tv_usec=0;
        ans.sentt.tv_sec=0;
        ans.sentt.tv_usec=0;
        ans.rect.tv_sec=0;
        ans.rect.tv_usec=0;
	tz.tz_minuteswest=0;      /* we'll be calculating the delta anyway */
	tz.tz_dsttime=0;

	gettimeofday(&start,&tz);

	fil=openport(server,port);

	gettimeofday(&finish,&tz);
	ans.connect=timevaldiff(finish,start);
	start=finish;

	if(fil<0)
	{
		ans.sentb=-2;
		return ans;
	}

	sprintf(buff,"GET %s HTTP/1.0\r\nAccept: */*\r\nUser-Agent: WebJamma\r\rHost: %s\r\n\r\n",page,server);
	size=write(fil,buff,strlen(buff));

	ans.sentb=size;

	c=1;
	errno=0;
	size=0;
	while(c>0)
	{
		alarm(first?itimeout:timeout);
		c=read(fil,buff,sizeof(buff));
		if (c>0)
		{
			size+=c;
		}
		if (first)   /* first read returning == transmit time.  */
		{
			gettimeofday(&finish,&tz);
			ans.sentt=timevaldiff(finish,start);
			start=finish;
		}
		first=0;
	}
	close(fil);
	gettimeofday(&finish,&tz);
	alarm(0);   /* cancel timeout */
	if ((c==-1))
		ans.recb=(errno==EINTR)?-1:-3;
	else
		ans.recb=size;

	ans.rect=timevaldiff(finish,start);
	return ans;
}

result clientpurge(char *server, int port, char *page)
{
	int fil,c;
	char buff[1024];
	int first=1;
	int size;
	struct timeval start,finish;
	struct timezone tz;
	result ans;
        ans.connect.tv_sec=0;
        ans.connect.tv_usec=0;
        ans.sentt.tv_sec=0;
        ans.sentt.tv_usec=0;
        ans.rect.tv_sec=0;
        ans.rect.tv_usec=0;
	tz.tz_minuteswest=0;      /* we'll be calculating the delta anyway */
	tz.tz_dsttime=0;

	gettimeofday(&start,&tz);

	fil=openport(server,port);

	gettimeofday(&finish,&tz);
	ans.connect=timevaldiff(finish,start);
	start=finish;

	if(fil<0)
	{
		ans.sentb=-2;
		return ans;
	}

	sprintf(buff,"PURGE %s HTTP/1.0\r\nAccept: */*\r\nUser-Agent: WebJamma\r\rHost: %s\r\n\r\n",page,server);
	size=write(fil,buff,strlen(buff));

	ans.sentb=size;

	c=1;
	errno=0;
	size=0;
	while(c>0)
	{
		alarm(first?itimeout:timeout);
		c=read(fil,buff,sizeof(buff));
		if (c>0)
		{
			size+=c;
		}
		if (first)   /* first read returning == transmit time.  */
		{
			gettimeofday(&finish,&tz);
			ans.sentt=timevaldiff(finish,start);
			start=finish;
		}
		first=0;
	}
	close(fil);
	gettimeofday(&finish,&tz);
	alarm(0);   /* cancel timeout */
	if ((c==-1))
		ans.recb=(errno==EINTR)?-1:-3;
	else
		ans.recb=size;

	ans.rect=timevaldiff(finish,start);
	return ans;
}

result clientpush(char *server, int port, char *page)
{
	int fil,c,r,l;
	int len;
	char buff[4096];
	char intheader[4096];
	char *body,*p;
	int bfil,bodylen,useintheader=0;
	int first=1;
	int size;
	struct timeval start,finish;
	struct timezone tz;
	result ans;
	struct stat st;
        ans.connect.tv_sec=0;
        ans.connect.tv_usec=0;
        ans.sentt.tv_sec=0;
        ans.sentt.tv_usec=0;
        ans.rect.tv_sec=0;
        ans.rect.tv_usec=0;
	tz.tz_minuteswest=0;      /* we'll be calculating the delta anyway */
	tz.tz_dsttime=0;

	bodylen=-1;

	body=page;                
	while(isspace(*body))  /* ignore leading white space */
		body++;
	while(!isspace(*body))  /* scan through URL  */
		body++;
	*body=0;                /* insert nul after URL in string */
	body++;                
	while(isspace(*body))   /* move body to after any white space */
		body++;
	p=body;
	while((*p!=0) && (!isspace(*p)))   /* we might find a length after the body */
		p++;
	if ((*p)!=0)   /* we found a length...  */
	{
		*p=0;     /* insert nul after the body in the string */
		p++;
		while(isspace(*p))
			p++;
		sscanf(p,"%d",&bodylen);
	}

#ifdef DEBUG
	fprintf(stderr,"%d: PUSH -%s-%s-%d\n",getpid(),page,body,bodylen);
#endif

	if (!strcmp(body,"-"))
	{
		useintheader=1;
		st.st_size=pushheader(intheader,sizeof(intheader),bodylen);
#ifdef DEBUG
		fprintf(stderr,"using internal header:  \n%s\n",intheader);
#endif
	}
	else
	{
		useintheader=0;
		bfil=open(body,O_RDONLY);
		fstat(bfil,&st);
	}
	gettimeofday(&start,&tz);

	fil=openport(server,port);

	gettimeofday(&finish,&tz);
	ans.connect=timevaldiff(finish,start);
	start=finish;

	if((fil<0) || ((intheader==0) && (bfil<0)))
	{
#ifdef DEBUG
		fprintf(stderr,"%d: open failed.  bfil=%d fil=%d\n",getpid(),bfil,fil);
#endif
		ans.sentb=-2;
		close(fil);
		close(bfil);
		return ans;
	}
	len=st.st_size;
	if (bodylen>0)
		len+=bodylen;

	sprintf(buff,"PUSH %s HTTP/1.0\r\nAccept: */*\r\nUser-Agent: WebJamma\r\rHost: %s\r\nContent-length: %d\r\nConnection: close\r\n\r\n",page,server,len);

#ifdef DEBUG
	fprintf(stderr,"%d: Query -%s-\n",getpid(),buff);
#endif

	l=strlen(buff);
	if (writen(fil,buff,l)!=l)
	{
		ans.sentb=-1;
		close(fil);
		close(bfil);
		return ans;
	}

	ans.sentb=size;

	alarm(timeout);     /* send body...  */
	if (useintheader)
	{
		r=0;
		c=1;
		while(c>0)
		{
			c=write(fil,&intheader[r],st.st_size-r);
			if (c>0)
			{
				ans.sentb+=c;
				r+=c;
			}
		}
	}
	else
	{
		c=1;
		while((c>0) && (r=read(bfil,buff,sizeof(buff)))>0)
		{
			alarm(timeout);
			c=write(fil,buff,r);   /* write block, and reset alarm */
			if (c>0)
				ans.sentb+=c;
		}
	}

	if (c<0)
	{
#ifdef DEBUG
		fprintf(stderr,"%d: first write failed.  bfil=%d fil=%d\n",getpid(),bfil,fil);
#endif
		ans.sentb=-2;
		close(fil);
		close(bfil);
		return ans;
	}

#ifdef DEBUG
	fprintf(stderr,"%d: starting second write\n",getpid());
#endif
	if (bodylen>0)
	{
		c=1;
		errno=0;
		while((bodylen>0) && (c>0))
		{
			makerandom(buff,sizeof(buff));
			r=(bodylen>sizeof(buff))?sizeof(buff):bodylen;
			alarm(timeout);
			c=write(fil,buff,r);   /* write block, and reset alarm */
			if (c>0)
			{
				ans.sentb+=c;
				bodylen-=c;
			}
#ifdef DEBUG
			fprintf(stderr,"%d: second write: bodylen=%d r=%d errno=%d\n",getpid(),bodylen,r,errno);
#endif
		}
	}

	if (c<0)
	{
#ifdef DEBUG
		fprintf(stderr,"%d: second write failed.  bfil=%d fil=%d\n",getpid(),bfil,fil);
#endif
		ans.sentb=-1;
		close(fil);
		close(bfil);
		return ans;
	}

#ifdef DEBUG
		fprintf(stderr,"%d: starting read \n",getpid());
#endif

	errno=0;       /* loop, reading a response from the server */
	first=1;
	size=0;
	do
	{
		alarm(first?itimeout:timeout);
		c=read(fil,&buff[size],sizeof(buff)-size);
		if (c>0)
		{
			size+=c;
		}
		buff[size]=0;
		if (first)   /* first read returning == transmit time.  */
		{
			gettimeofday(&finish,&tz);
			ans.sentt=timevaldiff(finish,start);
			start=finish;
		}
		first=0;
	}
	while((c>0) && (!strstr(buff,"\r\n\r\n")) && (!strstr(buff,"\n\n")) && (!strstr(buff,"\r\r")));


#ifdef DEBUG
	fprintf(stderr,"%d: %s\n",getpid(),buff);
#endif

	alarm(0);   /* cancel timeout */
	if ((c==-1))
	{
#ifdef DEBUG
		fprintf(stderr,"%d: read failed...\n",getpid());
#endif
		ans.recb=(errno==EINTR)?-1:-3;
	}
	else
		ans.recb=size;

	gettimeofday(&finish,&tz);
	ans.rect=timevaldiff(finish,start);   /* rect== time to receive response */

	close(fil);
	close(bfil);

	alarm(0);    /* cancel alarm */

	return ans;
}

int main(int argc, char *argv[])
{
	int i,j,rc,urlpip[2],flowpip[2];
	int kids[MAXKIDS],count;
	char url[URLSIZE],buff[1024];
	struct sigaction act,old;
	FILE *fil;

	if (argc<2)
	{
		fprintf(stderr,"%s [file]\n",argv[0]);
		exit(1);
	}

	if (!(fil=fopen(argv[1],"r")))
	{
		perror("open of conf file failed:");
		exit(1);
	}

	lineno=1;
	maxpar=10;
	numserver=0;
	numlog=0;
	reps=1;
	timeout=30;
	itimeout=30;
	yyin=fil;

	if (yyparse())
	{
		fprintf(stderr,"Error in conf file line %d.\n",lineno);
		exit(1);
	}
	fclose(fil);
	
	if (!numserver)
	{
		fprintf(stderr,"No servers specified.\n");
		exit(1);
	}
	if (!numlog)
	{
		fprintf(stderr,"No log files specified.\n");
		exit(1);
	}

	maxpar=maxpar*numserver;

	if (maxpar>MAXKIDS)
	{
		fprintf(stderr,"Too many processes, increase MAXKIDS, and recompile.\n");
		exit(1);
	}

#ifdef DEBUG
	printf("total kids: %d\nservers: %d\n",maxpar,numserver);
	for(i=0;i<numserver;i++)
		printf("%s %d\n",server[i],port[i]);

	printf("numlog: %d\n",numlog);
	for(i=0;i<numlog;i++)
		printf("%s\n",log[i]);
	printf("initial timeout %d  timeout %d\n",itimeout,timeout);
	printf("repeats %d\n",reps);
#endif

	/* make sure all the log files are ok... */
	for(i=0;i<numlog;i++)
	{
		if (!(fil=fopen(log[i],"r")))
		{
			sprintf(url,"open of log file %s failed",log[i]);
			perror(url);
			exit(1);
		}
		fclose(fil);
	}

	srand48(time(NULL) % (getpid() << 18) % (getppid() << 16));
	pipe(urlpip);   /* URL pipe, going from lead to all the kids */
	pipe(flowpip);  /* flow control pipe, from the kids back to lead */
	killem=0;

	for(i=0;i<maxpar;i++)
		switch (kids[i]=fork())
		{
			case -1: 
				for(j=0;j<i;j++)
					kill(kids[j],9);
				fprintf(stderr,"fork of kid %d\n",i);
				perror("webjamma: fork failed");
				exit(1);
				break;
			case 0: 
				kid(i,urlpip[0],flowpip[1],server,port,numserver);
				exit(1);
				break;
			default:
//				setpgid(kids[i],kids[i]);  /* all kids are in own process group */
		}			

	close(urlpip[0]);
	close(flowpip[1]);
	count=0;

	act.sa_handler=sigint;
	sigemptyset(&act.sa_mask);
	act.sa_flags=0;

	sigaction(SIGINT,&act,&old);

	for(j=0;(j<reps)&&(!killem);j++)
	{
#ifdef DEBUG
		printf("rep %d\n",j);
#endif
		for(i=0;(i<numlog)&&(!killem);i++)
		{
#ifdef DEBUG
			printf("log file %s\n",log[i]);
#endif
			fil=fopen(log[i],"r");
	
			while(!feof(fil) && (!killem))
			{

				while (count<1)
				{
					rc=read(flowpip[0],buff,sizeof(buff));
					if (rc>0)
						count+=rc;
				}
				if (fgets(url,sizeof(url),fil)!=NULL)
				{
					url[strlen(url)-1]=0;    /* lop off last char  (newline) */
					write(urlpip[1],url,sizeof(url));
					count--;
				}
			}
			fclose(fil);
		}
	}
	fprintf(stderr,"shutting down... count=%d\n",count);
	while(count<maxpar)     /* wait for all the kids to finish... */
	{
		rc=read(flowpip[0],buff,sizeof(buff));
		if (rc>0)
			count+=rc;
		fprintf(stderr,"count=%d\n",count);
	}

	/* kill off all the kids */
	for(j=0;j<maxpar;j++)
		kill(kids[j],9);

	exit(0);
}

int kid(int id, int urlpipe, int flowpipe,char *server[],int sport[],int numserver)
{
	int log=1;     /* FIXME: should be a file, not stdout... */
	char url[URLSIZE];
	int snum=id,i;
	char buff[URLSIZE+20];
	char logbuff[2048];    /* HARDCODED */
	struct sigaction act,old;
	result res[MAXSERVER];
        struct url spu;
        char page[URLSIZE],kidid,*host;
	int  port;

	act.sa_handler=sigalarm;
	sigemptyset(&act.sa_mask);
	act.sa_flags=0;
        
	sigaction(SIGALRM,&act,&old);
	sigaction(SIGPIPE,&act,&old);
	kidid=id;  /* we need the kid id in a char, for the flow control */

	srand48(time(NULL) % (getpid() << 18) % (getppid() << 16));
	while (write(flowpipe,&kidid,1)!=1)
		;   /* prime the flow control... */

	while(1)
	{
		read(urlpipe,url,sizeof(url));
#ifdef DEBUG
		sprintf(buff,"kid # %d (%d): start,    %s\n",id,getpid(),url);
		write(log,buff,strlen(buff));
#endif
		for (i=0;i<numserver;i++)
		{
			snum=(snum+1)%numserver;
                        if (proxy==0)
			{
                        	strcpy(page, url);
                        	spu=spliturl(page);
				host=spu.server;
				port=spu.port;
                        }
                        else
			{
				host=server[snum];
				port=sport[snum];
                        }

			interupted=0;
			if (!strncmp(url,"PUSH",4))
				res[snum]=clientpush(host,port,url+5);
			else if (!strncmp(url,"PURGE",5))
				res[snum]=clientpurge(host,port,url+5);
			else if (!strncmp(url,"GET",3))
				res[snum]=clientget(host,port,url+3);
			else
				res[snum]=clientget(host,port,url);   /* default is GET */
                     
#ifdef DEBUG
			if (res[snum].sentb>=0)
			{
				sprintf(buff,"kid # %d: complete, %s\n",id,url);
				write(log,buff,strlen(buff));
			}
			else
			{
				sprintf(buff,"kid # %d: timeout,  %s\n",id,url);
				write(log,buff,strlen(buff));
			}
#endif
		}
		sprintf(logbuff,"\"%s\" ",url);
		for(i=0;i<numserver;i++)
		{
 sprintf(buff,"%d %d %8.7f %8.7f %8.7f",res[i].sentb,res[i].recb,TIMEVALTOFLOAT(res[i].connect),TIMEVALTOFLOAT(res[i].sentt),TIMEVALTOFLOAT(res[i].rect));
			strcat(logbuff,buff);
		}
		strcat(logbuff,"\n");
		write(log,logbuff,strlen(logbuff));  /* a single syscall is atomic */
		while (write(flowpipe,&kidid,1)!=1)
			; /* tell lead we're ready */
	}
}

#ifdef ultrix
char *strdup(char *orig)
{
        char *p;
        p=malloc(strlen(orig)+1);
        strcpy(p,orig);
        return p;
}
#endif 

/* This writes to the string passed to it...
*/
struct url spliturl(char *url)
{
	char *currpos, *lastpos;
	struct url res;
	char str[URLSIZE];

	str[0]='/';
	str[1]='\0';
	res.server[0]='\0';
	res.port=80;
	res.url[0]='\0';

	lastpos=url;
	/* separate http:// part */
	currpos = strchr(lastpos, '/');
	if (currpos==NULL)
		return res;
	*currpos++='\0';
	lastpos=currpos;
	/* increment pointer to // part */
	lastpos++;
	/* machine part like memex.cs.vt.edu:80/ */
	/* separate machine part with url part */
	currpos=strchr(lastpos, '/');
	if (currpos!=NULL)
	{
		*currpos++='\0';
		strcat(str, currpos);
	}
	strcpy(res.url, str);
	currpos=strchr(lastpos, ':');
	if (currpos==NULL)
	{
		strcpy(res.server, lastpos);
		res.port=80;
	}
	else
	{
		*currpos++='\0';
 
		strcpy(res.server, lastpos);
		res.port=atoi(currpos);
	}
	return res;
}

/* generate a bunch of randomness */
void makerandom(char *buff,int len)
{
	int *ibuff;
	int ilen,i;

	ilen=len/(sizeof(long)/sizeof(char));

	ibuff=(int*)buff;    /* may cause a bus error...   */
	for(i=0;i<ilen;i++)
		ibuff[i]=lrand48();

//	ilen=ilen*(sizeof(long)/sizeof(char));
//	for(i=0;i<len-ilen;i++)
//		buff[i+ilen]=lrand48();
}

static int writen(int fil, char *buff,int len)
{
	int r,p;

	p=0;
	while(p<len)
	{
		errno=0;
		r=write(fil,buff+p,len-p);
		if (r>0)
			p+=r;
		else
		{
			if (errno!=EINTR)
				return p;
		}
	}
	return p;
}
