%{
#include<stdio.h>
#include"conf.tab.h"
#define DEFINE
#include"conf.h"

/*  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**  
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**  
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifdef NEEDYYWRAP
/* FreeBSD seems to need this */
int yywrap(void)
{
	return 1;
}
#endif

%}

%%

server	{return SERVER;}
maxpar	{return MAXPAR;}
inittimeout {return ITIMEOUT;}
timeout		{return TIMEOUT;}
log	{return LOG;}
repeat	{return REPEAT;}
proxy   {return PROXY;}

[0-9][0-9]*	{returnedint=strtoul(yytext,NULL,10);  return INT;}
\#.*$	{;}
\n	{lineno++;}
[ \t\n]+          /* eat up whitespace */ 
[^ \t\n]+	{return STRING;}

%%

