#ifndef METEORLIB_H
#define METEORLIB_H

typedef struct
{
	int fid;
	int wid,heit,depth;
	int nframe;
	unsigned char *buff;
	int mode;
	int bsize,fsize;    /* buffer size, frame size */

} meteorstruct;

/* valeus of mode:
*/
#define METEOR_SINGLE 1
#define METEOR_SYNC 2

meteorstruct * initmeteor(int width,int height,int _depth,int format,int nframe,int field,int input, int _gain, int _bri, int _con);
unsigned char *grabsingle(meteorstruct *met);
int meteorstatus(meteorstruct *met);

/* format is one of:
*/
#define METEORLIB_RGB 1
#define METEORLIB_YUV 2

void frame32to16 (unsigned char *imagedat,unsigned char *rawimagedat,int len);
void frame32to32 (unsigned int *imagedat,unsigned int *rawimagedat,int len);
void frame24to16 (unsigned char *imagedat,unsigned char *rawimagedat, int len);
void frame16to16 (unsigned char *buff2,unsigned char *yuv_data,int len);
void frame16to32 (unsigned int *buff2,unsigned short int *yuv_data, int len);
void frame24to32 (unsigned int *buff2,unsigned char *yuv_data, int len);
void frame16to24 (unsigned char *buff2,unsigned char *yuv_data, int len);
void frame32to24(unsigned char *output,unsigned int *input,int len);

#endif
