#include<stdio.h>
#include<fcntl.h>
#include<stdlib.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/fcntl.h>
#include <sys/signal.h>
#include <machine/ioctl_meteor.h>

/* This is the demo code from the meteor manpage on FreeBSD wearing a funny
** hat.  The original authors are Jim Lowe (james@miller.cs.uwm.edu)
** and Mark Tinguely (tinguely@plains.nodak.edu).  Modifications by
** Tommy Johnson  (protius@bobdbob.com)
*/

int video;     /* made global if you wish to stop capture in signal handler */
caddr_t data_frames;
struct meteor_mem *common_mem;
extern int errno;
char *buf;
int sig_cnt;

int framecnt;
int len;
int fil;

struct meteor_geomet geo;
int framelen;

#define FRAME_MAX 30

void getframe (char *frame,char buf[])
{
	int fp,p;

	fp=0;
	p=0;
	
	while (p<framelen)
       	{
		{
#ifdef BPP16
			buf[fp++]=((frame[p]&0x7C)<<1);
			buf[fp++]=((frame[p]&0x3)<<6)|((frame[p+1]&0xE0)>>2);
			buf[fp++]=((frame[p+1]&0x1F)<<3);
			p+=2;
#else
			buf[fp++]=frame[p+2];
			buf[fp++]=frame[p+1];
			buf[fp++]=frame[p];
			p+=4;
#endif
		}
	}
}

void
usr2_catcher()
{
struct meteor_capframe capframe;   /* for ioctl */
	char *frame;

	 /* find frame */
	frame = (char *) (data_frames + sig_cnt * common_mem->frame_size) ;

        /* add frame processing here */

	if ((len % 30)==0)
		fprintf(stderr,"frame %d\n",len);

#if 1
	getframe(frame,buf);
	write(fil,buf,geo.rows*geo.columns*3);
#else
	if (len&1)
		write(fil,frame,geo.rows*geo.columns*4);
#endif

	      /* deactivate frame */
	common_mem->active = common_mem->active & ~(1 << sig_cnt );
	common_mem->num_active_bufs--;

	 /* process next frame on next interrupt */
	sig_cnt = ((sig_cnt+1) % FRAME_MAX);

	len--;
	if (!len)
	{
		capframe.command=METEOR_CAP_STOP_FRAMES;

		if (ioctl(video, METEORCAPFRM, &capframe) < 0) {
			printf("METEORCAPFRM failed %d", errno);
			exit(1);
		}
	}
}

int main(int argc, char *argv[])
{
	int height, width, depth, frames, size,input;
	unsigned short status;
	struct meteor_capframe capframe;
	int c,i;
	unsigned char gain,bri,con,csat,usat;

	extern char *optarg;

	width=320;
	height=240;
	gain=127;
	bri=127;
	con=127;
	fil=1;
	len=1;
	input=METEOR_INPUT_DEV0;

        while((c=getopt(argc,argv,"w:h:f:l:g:b:c:i:?"))!=-1)
        switch (c)
        {
		case 'l':
			sscanf(optarg,"%d",&len);
			break;
                case 'w':
                        sscanf(optarg,"%d",&width);
                        break;
                case 'h':
                        sscanf(optarg,"%d",&height);
                        break;
                case 'g':
			sscanf(optarg,"%d",&c);
			gain=c;
			break;
		case 'b':
			sscanf(optarg,"%d",&c);
			bri=c;
			break;
		case 'c':
			sscanf(optarg,"%d",&c);
			con=c;
			break;
                case 'f':
			if ((fil=open(optarg,O_WRONLY|O_CREAT,0644))<0)
			{
				fprintf(stderr,"open of output file failed!\n");
				exit(1);
			}
			break;
               case 'i':
                        sscanf(optarg,"%d",&i);
                        switch (i)
                        {
                                case 0:
                                        input=METEOR_INPUT_DEV0; break;
                                case 1:
                                        input=METEOR_INPUT_DEV1; break;
                                case 2:
                                        input=METEOR_INPUT_DEV2; break;
                                case 3:
                                        input=METEOR_INPUT_DEV3; break;
                                case 4:
                                        input=METEOR_INPUT_DEV_RGB; break;
                                case 5:
                                        input=METEOR_INPUT_DEV_SVIDEO; break;
                                default:
                                        input=METEOR_INPUT_DEV0; break;
                        }
                        break;
		case '?':
			fprintf(stderr,"Usage: %s -w[width] -h[height] -g[gain] -b[brightness] -c[contrast] -i[input] -f[filename] -l[length]\ninput: 1-3: inputs 1-3  4: RGB 5:svideo\nlength: 1 - grab a single frame, >1: grab in sync for n frames\nfile: write to named file (default is stdout)\n",argv[0]);
			exit(1);
			break;
        }

	framecnt=0;
	if ((buf=malloc(width*height*3))==NULL)
	{
		printf("malloc of buf failed\n");
		exit(1);
	}

	if ((video = open("/dev/meteor0", O_RDONLY)) < 0) {
		printf("open failed");
		exit(1);
	}

	geo.columns = width;
	geo.rows = height;
	framelen=width*height*4;
	frames = geo.frames = (len==1)?1:FRAME_MAX;
#ifdef BPP16
	depth = 2;		   /* 2 bytes per pixel for RGB*/
	geo.oformat = METEOR_GEO_RGB16;
#else
	depth = 4;		   /* 4 bytes per pixel for RGB*/
	geo.oformat = METEOR_GEO_RGB24 | METEOR_GEO_EVEN_ONLY;
#endif
	if (ioctl(video, METEORSETGEO, &geo) < 0) {
		printf("METEORSETGEO failed %d\n", errno);
		exit(1);
	}

	c = METEOR_FMT_NTSC;

	if (ioctl(video, METEORSFMT, &c) < 0) {
		printf("ioctl failed: %d\n", errno);
		exit(1);
	}

	if (ioctl(video, METEORSINPUT, &input) < 0) {
		printf("ioctl failed: %d", errno);
		exit(1);
	}
/*
	if (ioctl(video, METEORSCHCV, &gain) < 0) {
		fprintf(stderr,"METEORSCHCV ioctl failed: %d", errno);
		exit(1);
	}
*/
	if (ioctl(video, METEORSBRIG, &bri) < 0) {
		fprintf(stderr,"METEORSBRIG ioctl failed: %d", errno);
		exit(1);
	}
	if (ioctl(video, METEORSCONT, &con) < 0) {
		fprintf(stderr,"METEORSCONT ioctl failed: %d", errno);
		exit(1);
	} 

	size = ((width*height*depth*frames+4095)/4096)*4096;
	    /* add one page after data for meteor_mem */
	data_frames = mmap((caddr_t)0, size + 4096, PROT_READ,
				       0, video, (off_t)0);

	if (data_frames == (caddr_t) -1)
	{
		fprintf(stderr,"mmap failed. %d\n",errno);
 		return (0);
	}

		    /* common_mem is located at page following data */
	common_mem = (struct meteor_mem *) (data_frames + size);

	signal(SIGUSR2, usr2_catcher);	  /* catch new frame message */

	if (ioctl(video, METEORSTATUS, &status) < 0) {
		fprintf(stderr,"METEORSTATUS ioctl failed: %d", errno);
		exit(1);
	} 
#ifdef DEBUG
	fprintf(stderr,"PLL: %s Time: %s Field: %s %sHz Color:%s\n",(status&METEOR_STATUS_HCLK)?"unlocked":"locked",(status&METEOR_STATUS_STTC)?"TV":"VCR",(status%METEOR_STATUS_OEF)?"even":"odd",(status&METEOR_STATUS_FIDT)?"60":"50",(status&METEOR_STATUS_CODE)?"Color":"Mono");
#endif

	sprintf(buf,"P6\n%d %d\n255\n",geo.columns,geo.rows);
	write(fil,buf,strlen(buf));

	if (len==1)
	{
		c=METEOR_CAP_SINGLE;
		ioctl(video,METEORCAPTUR,&c);  /* blocks until frame is captured... */
		getframe(data_frames,buf);
		write(fil,buf,width*height*3);
		close(fil);
	}
	else
	{
		capframe.command=METEOR_CAP_N_FRAMES;
		capframe.lowat=10;	   /* must be < hiwat */
		capframe.hiwat=20;	   /* must be < FRAME_MAX */

		c=SIGUSR2;
		if (ioctl(video, METEORSSIGNAL, &c) < 0) {
			printf("METEORSSIGNAL failed %d", errno);
			exit(1);
		}

			      /* start the sync capture */
		if (ioctl(video, METEORCAPFRM, &capframe) < 0) {
			fprintf(stderr,"METEORCAPFRM at about line 277 failed %d\n", errno);
			exit(1);
		}
		sleep((len/30)+5);
		  /* this is the background working area, or you can sleep */

		read(0,&c,1);

	       /* to stop capture */
		capframe.command=METEOR_CAP_STOP_FRAMES;

		if (ioctl(video, METEORCAPFRM, &capframe) < 0) {
			printf("METEORCAPFRM failed %d", errno);
			exit(1);
		}
	}
	close(video);
}
