#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#include<sys/types.h>
#include<sys/wait.h> 
#include<fcntl.h>
#include"meteorlib.h"
#include<machine/ioctl_meteor.h>

/* Copyright 1997,1998,2000 Tommy Johnson  All Rights Reserved
**
** Permission is hereby granted to copy, reproduce, redistribute or otherwise
** use this software as long as: there is no monetary profit gained
** specifically from the use or reproduction of this software, it is not
** sold, rented, traded or otherwise marketed, and this copyright notice is
** included prominently in any copy made.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
** SOFTWARE IS AT THE USER'S OWN RISK.
*/

#define GETINT(var) c=++p; while((*p) && (*p!=';')) p++; sscanf(c,"%d",&var); if (*p) p++;

#define BUSYIMAGE "busy.jpg"
#define NOSIGIMAGE "nosignal.jpg"

void dumpfile(int fd, char *nam);

int main(int argc, char *argv[])
{
	unsigned char *frame;
	meteorstruct *met;
	unsigned char header[1024],buff[4096];
	char *p,*c;
	int wid,heit,bri,con,gai,inp,i;
	int pip[2];
	pid_t kid;
	int stat;
	int sp,len;

	sp=open("/dev/speaker",O_WRONLY);
	strcpy(header,"l32eppeppeppl4c\n");
	if (sp>=0)
		write(sp,header,strlen(header));
	close(sp);

	wid=320;
	heit=240;
	bri=127;
	con=127;
	gai=127;
	inp=0;
	if (argv[1])
		p=strdup(argv[1]);
	else
		p=strdup("");
	while(*p)
	{
		switch (*p)
		{
			case 'w':
				GETINT(wid);
			break;
			case 'h':
				GETINT(heit);
			break;
			case 'b':
				GETINT(bri);
			break;
			case 'c':
				GETINT(con);
			break;
			case 'g':
				GETINT(gai);
			break;
			case 'i':
				GETINT(inp);
			break;
			default:
				while((*p) && (*p!=';'))
					p++;
				p++;
		}
	}

	sprintf(header,"Content-type: image/jpeg\r\n\r\n");
	write(1,header,strlen(header));

	met=initmeteor(wid,heit,METEORLIB_RGB,4,1,(heit<=320),inp,gai,bri,con);
	if (!met)
		dumpfile(1,BUSYIMAGE);

	if (meteorstatus(met)&METEOR_STATUS_HCLK)
		dumpfile(1,NOSIGIMAGE);

	frame=malloc(wid*heit*3);
	for(i=0;i<20;i++)
		grabsingle(met);

	frame32to24(frame,grabsingle(met),wid*heit);

	pipe(pip);
	switch(kid=fork())
	{
		case -1:
			exit(1);
		break;
		case 0:
			close(0);
			dup(pip[0]);
			close(pip[0]);
			close(pip[1]);
			execl("/usr/local/bin/cjpeg","cjpeg",NULL);
			fprintf(stderr,"execlp failed\n");
			exit(1);
		break;
	}

	sprintf(header,"P6\n%d %d\n255\n",wid,heit);
	write(pip[1],header,strlen(header));
	write(pip[1],frame,wid*heit*3);
	waitpid(kid,&stat,0);
	return(0);
}

void dumpfile(int fd, char *nam)
{
	int sp,len;
	char buff[4096];

	sp=open(nam,O_RDONLY);
	if (sp<0)
		exit(1);
	while((len=read(sp,buff,sizeof(buff)))>0)
		write(1,buff,len);
	close(sp);
}
