#ifndef PPMIO_H
#define PPMIO_H

int convertRGB2YUV(int incols,int inrows, unsigned char *rgb,unsigned char *y,unsigned char *u,unsigned char *v, int CCIR601,int bpp);
int convertYUV2RGB(int cols,int  rows,unsigned char *iny,unsigned char * inu,unsigned char * inv,unsigned char * out,int CCIR601,int bpp);

/* Format codes:
**  P7:    RGBI      4 bytes per pixel.
**  P8:    RGB       3 bytes per pixel.
**  P9:    YUV 422   2 bytes per pixel.
**
**  The frame is then followed by the audio data.  There are overshoot 
**  samples allocated, so frames are a constant size (all the better to
**  seek with), but the last sample is ignored, depending on the dropsample
**  scheme.
**
**  dropsample code:
**  two numbers, first is overshoot count, second one is period.  For NTSC
**   29.97 fps, with 44.1KHz audio, the code would be 157 333.  (1472 samples
**   for 157 frames, then 1471 samples for the rest up to 333.
**
**  Film's 24 fps would be 1 2 (1837 samples for 1 frame, then 1838 samples
**   for 1 frame).
**
** The sample counts come from floor(44.1 KHz / frame rate)  overshoot is
**  that number+1.
*/

#define PPM_P7 7
#define PPM_P8 8
#define PPM_P9 9

typedef struct
{
	long int wid,heit;
	int audiofreq,audionchan,audiosampsize;   /* in Hz, number of channels, size of sample in bytes */
	int framerate, imageformat;    /* in thousanth's of a frame/sec */

	/* computed and cached here for speed */
	int framelen;
	int offset,overshoot,period;

	/* Private vars */
	FILE *fil;
	long long int siz,hlen;
	unsigned char *buff;

} ppmstruct;

ppmstruct *ppmopen(char *name);
ppmstruct *ppmopenread(char *name);
// ppmstruct *ppmopenwrite(char *name, int format, framerate, width, height, audiorate, nchan, samplesize);
ppmstruct *ppmopenwrite(char *name, int format);
void ppmclose(ppmstruct *ps);

int ppmGetHeader(FILE *fil, long int *width,long int *height);

/*
** if audio pointer is NULL, will not return audio
*/

int ppmloadframeYUV(ppmstruct *fil,int fr,unsigned char *image,unsigned char *audio);
int ppmloadframeYUVp(ppmstruct *fil,int fr,unsigned char *y,unsigned char *u,unsigned char *v,unsigned char *audio);
int ppmloadframeRGB(ppmstruct *fil,int fr,unsigned char *image,unsigned char *audio);
int ppmloadframeRBPp(ppmstruct *fil,int fr,unsigned char *r,unsigned char *g,unsigned char *b,unsigned char *audio);


int ppmloadaudio(ppmstruct *fil, int fr, unsigned char *dat);
int ppmframelen(int fr);

#define ppmgetwidth(ps) (ps->wid)
#define ppmgetheight(ps) (ps->heit)

#endif
