#include<stdio.h>
#include<stdlib.h>
#include"ppmio.h"

#define BPP 2

/* see videocat for an explenation of this...
*/

int ppmframelen(int fr)
{
        if ((fr%333)<157)
                return 1472*4;
        else
                return 1471*4;
}   

int convertRGB2YUV(int incols,int inrows, unsigned char *rgb,unsigned char *y,unsigned char *u,unsigned char *v, int CCIR601, int bpp);

int ppmGetHeader(FILE *fil, long int *width,long int *height)
{
	int a,comment,max;
	char temp[2];

	fread(temp,1,2,fil);
	if ((temp[0]!='P') || (temp[1]!='7'))
		return -1;

	comment=0;
	while (!comment)
	{
		comment=1;
		while (isspace(a=fgetc(fil)))
			;
		if (a=='#')
		{
			while((a=fgetc(fil))!='\n')
				;
			comment=0;
		}
	ungetc(a,fil);
	}

	fscanf(fil,"%d",width);
	comment=0;
	while (!comment)
	{
		comment=1;
		while (isspace(a=fgetc(fil)))
			;
		if (a=='#')
		{
			while((a=fgetc(fil))!='\n')
				;
			comment=0;
		}
	ungetc(a,fil);
	}

	fscanf(fil,"%d",height);
	comment=0;
	while (!comment)
	{
		comment=1;
		while (isspace(a=fgetc(fil)))
			;
		if (a=='#')
		{
			while((a=fgetc(fil))!='\n')
				;
			comment=0;
		}
	ungetc(a,fil);
	}
	comment=0;
	while (!comment)
	{
		comment=1;
		while (isspace(a=fgetc(fil)))
			;
		if (a=='#')
		{
			while((a=fgetc(fil))!='\n')
				;
			comment=0;
		}
	ungetc(a,fil);
	}
	fscanf(fil,"%d",&max);
	while((a=fgetc(fil))!='\n')
		;
	return 0;
}

ppmstruct *ppmopen(char *name)
{
	ppmstruct *ps;

	ps=malloc(sizeof(ppmstruct));
	if (ps==NULL)
		return NULL;

	ps->fil=fopen(name,"r");
	if (!ps->fil)     /* if open failed */
	{
		free(ps);
		return NULL;
	}
	ppmGetHeader(ps->fil,&ps->wid,&ps->heit);
	ps->hlen=ftell(ps->fil);
	ps->siz=ps->wid*ps->heit*BPP + (1472*2*2);   /* image, plus audio...  */
	ps->buff=malloc(ps->siz);

	return ps;
}

void ppmclose(ppmstruct *ps)
{
	fclose(ps->fil);
	free(ps->buff);
	free(ps);
}

int ppmloadframe(ppmstruct *ps,int fr,unsigned char *y,unsigned char *u,unsigned char *v,unsigned char *audio)
{
	int i,j,xp,yp;
	unsigned char *buff1,*ue,*ve;

	if (fseeko(ps->fil,ps->hlen+(long long int)fr*ps->siz,SEEK_SET)<0)
		return -1;
	if (fread(ps->buff,ps->siz,1,ps->fil)!=1)
		return -2;

	ue=u;
	ve=v;

/* Assume image is all Y, followed by all U, followed by all V
*/
#if 0
	memcpy(y,ps->buff,(ps->wid*ps->heit));
	buff1=ps->buff+(ps->wid*ps->heit);

	for(i=0;i<(ps->heit/2);i++)
	{
		memcpy(ue,      buff1             , ps->wid/2);
		buff1+=(ps->wid/2);
		ue+=ps->wid/2;
		memcpy(ve,buff1+(ps->wid*ps->heit/2), ps->wid/2);
		buff1+=(ps->wid/2);
		ve+=ps->wid/2;
	}
#endif
#if 0
	memcpy(y,ps->buff,(ps->wid*ps->heit)*BPP);
#endif
/* Assume image is RGBA
*/
#if 0
	convertRGB2YUV(ps->wid,ps->heit,ps->buff,y,u,v,1,4);
#endif

/* Assume image is Y U Y V ...  per pixel
*/
#if 1
	xp=0;
	yp=0;
	for(i=0;i<(ps->wid*ps->heit);i++)
	{
		y[xp+(yp*ps->wid)]=ps->buff[1+i*2];

		xp++;
		if (xp>=ps->wid)
		{
			xp=0;
			yp++;
		}
	}

	i=0;
	j=0;
	for(yp=0;yp<ps->heit/2;yp++)
	{
		for(xp=0;xp<ps->wid/2;xp++)
		{
			u[j]=(ps->buff[i] + ps->buff[i+ps->wid*2])/2;
			i+=2;
			v[j]=(ps->buff[i] + ps->buff[i+ps->wid*2])/2;
			i+=2;
			j++;
		}
		i+=ps->wid*2;
	}
#endif
	if (audio!=NULL)
		memcpy(audio,ps->buff+((ps->wid*ps->heit)*BPP),ppmframelen(fr));

	return ppmframelen(fr);
}

int ppmloadaudio(ppmstruct *ps, int fr, unsigned char *dat)
{
	int i;

	i=fseeko(ps->fil,(ps->wid*ps->heit*BPP) + (ps->hlen+(long long int)fr*ps->siz),SEEK_SET);
	if (i<0)
		return -1;
	if ((i=fread(dat,1,1472*2*2,ps->fil))!=(1472*2*2))
		return -1;

	return ppmframelen(fr);
}

/*************************************************************
Copyright (C) 1990, 1991, 1993 Andy C. Hung, all rights reserved.
PUBLIC DOMAIN LICENSE: Stanford University Portable Video Research
Group. If you use this software, you agree to the following: This
program package is purely experimental, and is licensed "as is".
Permission is granted to use, modify, and distribute this program
without charge for any purpose, provided this license/ disclaimer
notice appears in the copies.  No warranty or maintenance is given,
either expressed or implied.  In no event shall the author(s) be
liable to you or a third party for any special, incidental,
consequential, or other damages, arising out of the use or inability
to use the program for any purpose (or the loss of data), even if we
have been advised of such possibilities.  Any public reference or
advertisement of this source code should refer to it as the Portable
Video Research Group (PVRG) code, and not by any author(s) (or
Stanford University) name.
*************************************************************/
/*
************************************************************
ppm2cyuv.c

This program separates a raw ppm input file into component YUV files
with a sampling ratio of 4:1:1 (the same pattern as MPEG 4:2:0).  The
output is placed in .Y .U .V by default.

The ppm description and files are part of Jef Poskanzer's PBMPLUS
library.  This is just a short-cut program to do a simple YUV
conversion.

************************************************************
*/

#include <stdio.h>

#define PPM_MAGIC1 'P'
#define PPM_MAGIC2 '3'
#define RPPM_MAGIC2 '6'
#define FIXNUM 16

#define FIX(a,b) ((int)((a)*(1<<(b))))
#define UNFIX(a,b) ((a+(1<<(b-1)))>>(b))

/* Approximate 255 by 256 */
#define CCIRUV(x) (((((x)-128)*224)>>8)+128)
#define CCIRY(x) (((((x))*219)>>8)+16)

#define CLIP(t) (((t)>255)?255:(((t)<0)?0:(t)))
#define GETY(r,g,b) UNFIX((FIX(0.299,FIXNUM)*(r)+\
			   FIX(0.587,FIXNUM)*(g)+\
			   FIX(0.144,FIXNUM)*(b)),FIXNUM)
#define GETU(r,g,b) UNFIX((FIX(-0.1687,FIXNUM)*(r)+\
			   FIX(-0.3313,FIXNUM)*(g)+\
			   FIX(0.5,FIXNUM)*(b)),FIXNUM)
#define GETV(r,g,b) UNFIX((FIX(0.5,FIXNUM)*(r)+\
			   FIX(-0.4187,FIXNUM)*(g)+\
			   FIX(-0.0813,FIXNUM)*(b)),FIXNUM)

char *suffix[3] = {".Y",".U",".V"};


/* bpp argument is bytes per pixel.  
** The frame grabber is 4 bpp, but ppm files are 3bpp...
*/
int
convertRGB2YUV(int incols,int inrows, unsigned char *rgb,unsigned char *y,unsigned char *u,unsigned char *v, int CCIR601,int bpp)
{
  int i,j;
  int r1,r2,r3,r4,g1,g2,g3,g4,b1,b2,b3,b4;
  int magic1, magic2;
  int maxval;
  int outcols,outrows;
  int temp;
  char inpstring[256];
  unsigned char *temprgb1, *temprgb2, *tempy1, *tempy2, *tempu, *tempv;
  unsigned char *rgb1p, *rgb2p, *y1p, *y2p, *up, *vp;

  maxval=255;

    /* output size is always even...   */
  if (inrows&1) outrows = inrows-1;
  else outrows = inrows;
  if (incols&1) outcols = incols-1;
  else outcols = incols;


#if 0
  temprgb1 = (unsigned char *) calloc(incols*bpp,sizeof(char));
  temprgb2 = (unsigned char *) calloc(incols*bpp,sizeof(char));
  tempy1 = (unsigned char *) calloc(outcols,sizeof(char));
  tempy2 = (unsigned char *) calloc(outcols,sizeof(char));
  tempu = (unsigned char *) calloc(outcols>>1,sizeof(char));
  tempv = (unsigned char *) calloc(outcols>>1,sizeof(char));
#endif

  for(i=0;i<(outrows>>1);i++)
    {
      rgb1p = &rgb[(i*2)*bpp*incols];
      rgb2p = &rgb[(i*2+1)*bpp*incols];

      y1p = &y[i*2*outcols];
      y2p = &y[(i*2+1)*outcols];
      up = &u[i*(outcols>>1)];
      vp = &v[i*(outcols>>1)];

      for(j=0;j<(outcols>>1);j++)
	{
	  b1 = *(rgb1p++);
	  g1 = *(rgb1p++);
	  r1 = *(rgb1p++);
	  if (bpp>3)
		rgb1p+=bpp-3;
	  b2 = *(rgb1p++);
	  g2 = *(rgb1p++);
	  r2 = *(rgb1p++);
	  if (bpp>3)
		rgb1p+=bpp-3;

	  b3 = *(rgb2p++);
	  g3 = *(rgb2p++);
	  r3 = *(rgb2p++);
	  if (bpp>3)
		rgb2p+=bpp-3;
	  b4 = *(rgb2p++);
	  g4 = *(rgb2p++);
	  r4 = *(rgb2p++);
	  if (bpp>3)
		rgb2p+=bpp-3;

	  if (CCIR601)
	    {
	      temp=GETY(r1,g1,b1);
	      temp=CLIP(temp);
	      *(y1p++) = CCIRY(temp);
	      temp=GETY(r2,g2,b2);
	      temp=CLIP(temp);
	      *(y1p++) = CCIRY(temp);
	      temp=GETY(r3,g3,b3);
	      temp=CLIP(temp);
	      *(y2p++) = CCIRY(temp);
	      temp=GETY(r4,g4,b4);
	      temp=CLIP(temp);
	      *(y2p++) = CCIRY(temp);
	      
	      /* We use a box filter for decimation */
	      
	      temp = ((GETU(r1+r2+r3+r4,g1+g2+g3+g4,b1+b2+b3+b4)
		       +(1<<9)+(1<<1))>>2);
	      temp=CLIP(temp);
	      *(up++) = CCIRUV(temp);
	      temp = ((GETV(r1+r2+r3+r4,g1+g2+g3+g4,b1+b2+b3+b4)
		       +(1<<9)+(1<<1))>>2);
	      temp=CLIP(temp);
	      *(vp++) = CCIRUV(temp);
	    }
	  else
	    {
	      temp=GETY(r1,g1,b1);
	      *(y1p++) = CLIP(temp);
	      temp=GETY(r2,g2,b2);
	      *(y1p++) = CLIP(temp);
	      temp=GETY(r3,g3,b3);
	      *(y2p++) = CLIP(temp);
	      temp=GETY(r4,g4,b4);
	      *(y2p++) = CLIP(temp);
	      
	      /* We use a box filter for decimation */
	      
	      temp = ((GETU(r1+r2+r3+r4,g1+g2+g3+g4,b1+b2+b3+b4)
		       +(1<<9)+(1<<1))>>2);
	      *(up++) = CLIP(temp);
	      temp = ((GETV(r1+r2+r3+r4,g1+g2+g3+g4,b1+b2+b3+b4)
		       +(1<<9)+(1<<1))>>2);
	      *(vp++) = CLIP(temp);
	    }
	}
#if 0
      fwrite(tempy1,1,outcols*sizeof(char),outy);
      fwrite(tempy2,1,outcols*sizeof(char),outy);
      fwrite(tempu,1,(outcols>>1)*sizeof(char),outu);
      fwrite(tempv,1,(outcols>>1)*sizeof(char),outv);
#endif
    }
}

/*************************************************************
Copyright (C) 1990, 1991, 1993 Andy C. Hung, all rights reserved.
PUBLIC DOMAIN LICENSE: Stanford University Portable Video Research
Group. If you use this software, you agree to the following: This
program package is purely experimental, and is licensed "as is".
Permission is granted to use, modify, and distribute this program
without charge for any purpose, provided this license/ disclaimer
notice appears in the copies.  No warranty or maintenance is given,
either expressed or implied.  In no event shall the author(s) be
liable to you or a third party for any special, incidental,
consequential, or other damages, arising out of the use or inability
to use the program for any purpose (or the loss of data), even if we
have been advised of such possibilities.  Any public reference or
advertisement of this source code should refer to it as the Portable
Video Research Group (PVRG) code, and not by any author(s) (or
Stanford University) name.
*************************************************************/
/*
************************************************************
cyuv2ppm.c

This program converts component YUV files with a sampling ratio of
4:1:1 (the same pattern as MPEG 4:2:0; the files read from .Y .U .V by
default) into a single raw ppm file.

The ppm description and files are part of Jef Poskanzer's PBMPLUS
library.  This is just a short-cut program to do a simple RGB
conversion.

************************************************************
*/

#define FIX(a,b) ((int)((a)*(1<<(b))))
#define UNFIX(a,b) ((a+(1<<(b-1)))>>(b))

/* Approximate 255 by 256 */
#define ICCIRUV(x) (((x)<<8)/224)
#define ICCIRY(x) ((((x)-16)<<8)/219)

#define CLIP(t) (((t)>255)?255:(((t)<0)?0:(t)))
#define GETR(y,u,v) UNFIX((FIX(1.0,FIXNUM)*(y)+\
			   FIX(1.402,FIXNUM)*(v)),FIXNUM)
#define GETG(y,u,v) UNFIX((FIX(1.0,FIXNUM)*(y)+\
			   FIX(-0.34414,FIXNUM)*(u)+\
			   FIX(-0.71414,FIXNUM)*(v)),FIXNUM)
#define GETB(y,u,v) UNFIX((FIX(1.0,FIXNUM)*(y)+\
			   FIX(1.772,FIXNUM)*(u)),FIXNUM)

int convertYUV2RGB(int cols,int  rows,unsigned char *iny,unsigned char * inu,unsigned char * inv,unsigned char * out,int CCIR601,int bpp)
{
  int i,j;
  int y1,y2,y3,y4,u1,v1;
  int temp;
  unsigned char *temprgb1, *temprgb2, *tempy1, *tempy2, *tempu, *tempv;
  unsigned char *rgb1p, *rgb2p, *y1p, *y2p, *up, *vp;

  if ((rows&1)||(cols&1))
    {
      printf("rows and columns must be multiple of 2\n");
      exit(-1);
    }
  for(i=0;i<(rows>>1);i++)
    {
      rgb1p = out+(i*2*cols*bpp);
      rgb2p = out+((i*2+1)*cols*bpp);
      y1p = iny+(i*2*cols);
      y2p = iny+((i*2+1)*cols);
      up = inu+(i*cols/2);
      vp = inv+(i*cols/2);

      for(j=0;j<(cols>>1);j++)
	{                      /* We use pel replication for interpolation */
	  y1 = *(y1p++);
	  y2 = *(y1p++);
	  y3 = *(y2p++);
	  y4 = *(y2p++);

	  u1 = *(up++);
	  v1 = *(vp++);
	  u1 -=128;
	  v1 -=128;

	  if (CCIR601)
	    {
	      y1 = ICCIRY(y1);
	      y2 = ICCIRY(y2);
	      y3 = ICCIRY(y3);
	      y4 = ICCIRY(y4);

	      u1 = ICCIRUV(u1);
	      v1 = ICCIRUV(v1);
	    }

	  temp=GETR(y1,u1,v1);
	  *(rgb1p++) = CLIP(temp);
	  temp=GETG(y1,u1,v1);
	  *(rgb1p++) = CLIP(temp);
	  temp=GETB(y1,u1,v1);
	  *(rgb1p++) = CLIP(temp);
	  *(rgb1p++)=0;  /* alpha */

	  temp=GETR(y2,u1,v1);
	  *(rgb1p++) = CLIP(temp);
	  temp=GETG(y2,u1,v1);
	  *(rgb1p++) = CLIP(temp);
	  temp=GETB(y2,u1,v1);
	  *(rgb1p++) = CLIP(temp);
	  *(rgb1p++)=0;  /* alpha */

	  temp=GETR(y3,u1,v1);
	  *(rgb2p++) = CLIP(temp);
	  temp=GETG(y3,u1,v1);
	  *(rgb2p++) = CLIP(temp);
	  temp=GETB(y3,u1,v1);
	  *(rgb2p++) = CLIP(temp);
	  *(rgb2p++)=0;  /* alpha */

	  temp=GETR(y4,u1,v1);
	  *(rgb2p++) = CLIP(temp);
	  temp=GETG(y4,u1,v1);
	  *(rgb2p++) = CLIP(temp);
	  temp=GETB(y4,u1,v1);
	  *(rgb2p++) = CLIP(temp);
	  *(rgb2p++)=0;  /* alpha */

	}
     }
}

