/******************************************************************************
 *
 * Copyright (c) 1994-1999 Palm Computing, Inc. or its subsidiaries.
 * All rights reserved.
 *
 * File: FingerDemo.h
 *
 * History:
 *		01/04/97		Gregory Toto, created. 
 *
 *****************************************************************************/

#include "myquoteRsc.h"

#define RECORDERLEN 8
#define CARDNUMBER 0

// useful debugging tools on the device when the serial port is occupied
// and you can't use the nifty source code debugger...

#define	AlertPrintf1(a)					FrmCustomAlert(PrintfAlert,(a)," "," ")
#define	AlertPrintf2(a,b)					FrmCustomAlert(PrintfAlert,(a),(b)," ")
#define	AlertPrintf3(a,b,c)				FrmCustomAlert(PrintfAlert,(a),(b),(c))

#define AlertPrintf							AlertPrintf2

typedef struct
{
        Char recorder[RECORDERLEN+1];
        UInt16 seqnum;
} myquotePrefs;

typedef struct 
{
	UInt16 recorderlen;
	UInt16 seqnumber;
	UInt32 timestamp;
	Char *recorder;
	Char *quote;

	DmOpenRef db;
	UInt16 recno;
	Char *handleptr;
} myquote;

#define QuoteDBNameStr		"myquoteDB"
#define QuoteCreator		'USQM'
#define QuoteDBType		'DATA'
#define QuoteExtension		"usq"

#define ChunkSize               20

static Boolean openQuoteDatabase( void );
void ClobberQuoteDatabase( Boolean showErrDialog );
static UInt16 displayRecord(FormPtr frmP,UInt16 recno);
static UInt16 insertRecord(FormPtr frmP,UInt16 recno);
static UInt16 readQuoteRecord(DmOpenRef *db,UInt16 recno,myquote *quote);
static UInt16 writeQuoteRecord(DmOpenRef *db,UInt16 recno, myquote *quote);
static UInt16 unmarshalQuoteRecord(unsigned char *recrd,myquote *quote);
static UInt16 marshalQuoteRecord(unsigned char *buff,myquote *quote);
static UInt16 getQuoteLength(myquote *quote);

static Err beamQuotesDatabase(DmOpenRef db);
static Err ReceiveData(ExgSocketPtr exgSocketP);
static UInt16 AcceptBeam(GoToParamsPtr gtP, Boolean launched);

static void LoadPrefsRecord(myquotePrefs *pref);
static void SavePrefsRecord(myquotePrefs *pref);
static void DispPrefs(FormPtr frmP,myquotePrefs *prefs);
static void ReadPrefs(FormPtr prefform,myquotePrefs *prefs);

void ShowControl( FormPtr formP, UInt16 controlID, Boolean showTheControl );

FieldPtr SetFieldTextFromStr( FormPtr formP, UInt16 fieldID, MemPtr strP );
FieldPtr SetFieldTextFromRes( FormPtr formP, UInt16 fieldID, UInt16 strID );

FieldPtr ClearFieldText( FormPtr formP, UInt16 fldID );
void ShowErrorDialog( UInt16 stringID, MemPtr aStrPtr );
void ShowErrorDialog2( UInt16 stringID1,  UInt16 stringID2 );
void UpdateScrollBar( FieldPtr fldP, ScrollBarPtr barP );
void ScrollField( FieldPtr fldP, ScrollBarPtr barP, Int16 linesToScroll );
void PageScroll( FieldPtr fldP, ScrollBarPtr barP, WinDirectionType direction );


//=======================================================================

extern UInt16		gCurrentFrmID;
extern DmOpenRef	gQuoteDB;	

