#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

/* This is intended to make images of floppies, with some sort of useful
** retry for IO errors on individual disk sectors.  (as opposed to dd, which
** aborts completely on the first IO error)
**
** $Id: diskimage.c,v 1.2 2009/05/17 14:18:01 protius Exp $
**
** Copyright 2004, 2009 Tommy Johnson
*/

#define SECTORSIZE 512

int main(int argc, char *argv[])
{
	int track=80;
	int sector=18;
	int heads=2;
	char *dev=NULL;

	int diskfd;
	unsigned char *image;
	unsigned char *secflag;
	int i;
	int numsec;
	int retries=3;
	int onefailed=1;

	while((i=getopt(argc,argv,"t:s:h:d:r:?"))!=-1)
	switch(i)
	{
		default:
			fprintf(stderr,"diskimage - like dd, only it will retry failed sectors\n"
			"The image is written to stdout\n"
			"-t int   - number of tracks\n"
			"-s int   - number of sectors\n"
			"-h int   - number of heads\n"
			"-d name  - device name\n"
			"-r int   - number of retries\n"
			" 3.5  inch 1.44MB     80   18   2\n"
			" 3.5  inch 720K       80    9   2\n"
			" 5.25 inch 360K       40    9   2\n"
			"\nCopyright 2004, 2009 Tommy Johnson\n"
			);
			exit(1);
		break;
		case 't':
			sscanf(optarg,"%d",&track);
		break;
		case 's':
			sscanf(optarg,"%d",&sector);
		break;
		case 'r':
			sscanf(optarg,"%d",&retries);
		break;
		case 'h':
			sscanf(optarg,"%d",&heads);
		break;
		case 'd':
			fprintf(stderr,"arg device: %s\n",optarg);
			dev=strdup(optarg);
		break;
	}

	numsec=track*sector*heads;

	if (dev==NULL)
	{
		fprintf(stderr,"specify a device.\n");
		exit(1);
	}
	fprintf(stderr,"device: %s\n",dev);
	diskfd=open(dev,O_RDONLY);
	if (diskfd<0)
	{
		perror("main: open of device");
		exit(1);
	}

	image=malloc(numsec*SECTORSIZE);
	secflag=malloc(numsec);

	for(i=0;i<numsec;i++)     /* These are set to 1 as successfully read */
		secflag[i]=0;         

	while((retries>0) && (onefailed))
	{
		for(i=0;i<numsec;i++)
		{
			if (!secflag[i])
			{
				fprintf(stderr,"%i\n",i);
				lseek(diskfd,i*SECTORSIZE,SEEK_SET);
				if (read(diskfd,image+(i*SECTORSIZE),SECTORSIZE)==SECTORSIZE)
					secflag[i]=1;
			}
		}

		onefailed=0;
		fprintf(stderr,"failed sectors: ");
		for(i=0;i<numsec;i++)
		{
			if (!secflag[i])
			{
				fprintf(stderr,"%d, ",i);
				onefailed=1;
			}
		}
		fprintf(stderr,"\n");

		retries--;
	}

	write(1,image,numsec*SECTORSIZE);
	return 0;
}
