#include<stdio.h>
#ifdef linux
#include<gnu/types.h>
#else
#include<sys/types.h>
#endif
#include<sys/socket.h>
#ifdef u3b
#include<sys/in.h>
#include<sys/inet.h>
#else
#include<netinet/in.h>
#endif
#include<netdb.h>
/* #include<termio.h> */

/*  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**  
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**  
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


/* openport - establishes a connection to a remote machine at port
** port, and returns a file handle.
** return -1 if socket fails
**        -2 if host unknown
**        -3 if connect fails
*/
int openport(char *machine, int port)
{
	struct hostent *remote;
	struct sockaddr_in sock;
	int plug;

	if ((plug=socket(AF_INET,SOCK_STREAM,0)) < 0) {
                close(plug);
		return -1;
        }

	sock.sin_family = AF_INET;

	if ((remote=gethostbyname(machine))==NULL) {
                close(plug);
		return -2;
        }

	bcopy((char*)remote->h_addr,(char*)&sock.sin_addr,remote->h_length);
	sock.sin_port=htons(port);

	if (connect(plug,(struct sockaddr *)&sock,sizeof(sock)) < 0) {
                close(plug);
		return -3;
	}
	return plug;
}
