#ifndef MULTIPLEX_H
#define MULTIPLEX_H

typedef struct
{
	int fd;
	int step;
	int data;

} Multiplex;

/* Open a multiplex plate holder, on device *dev.
 * This may take a while to return, since it finds the 0 point.
 *
 * If cal is set to MUTLIPLEX_NOCALIBRATE, it will not find the 0 point.
 */
#define MULTIPLEX_NOCALIBRATE 0
#define MULTIPLEX_CALIBRATE 1

Multiplex *multiplexInit(char *dev,int cal);

/* Walk till we hit the top limit:
 */
int multiplexTop(Multiplex *m);

/* Walk till we hit the bottom limit.
 */

int multiplexBottom(Multiplex *m);

/* Take direction steps.  positive numbers are up
 * negative numbers are down. 
 * returns the current step the plate holder is at.
 * If the limit switches are hit, does nothing.  
 */
int multiplexStepMove(Multiplex *m, int direction);

/* Return current step
 */
int multiplexStep(Multiplex *m);

/* Return the values of the limit switches
 */
int multiplexLimitTop(Multiplex *m);
int multiplexLimitBottom(Multiplex *m);

/* Make an exposure.  The time is in milliseconds
 */
int multiplexExpose(Multiplex *m, int time);

#endif
