#include<stdio.h>
#include <stdlib.h>

/* 
**
** This attempts to decode the hour meter on a Compass 315M laser using
** a phototransistor on a microphone input.
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/


// #define BITLEN (48000*0.00333)
#define BITLEN (160)

#define MAG  32766

int main(int argc, char *argv[])
{
	int *buff=NULL;
	int len=0;
	int curlen=0;
	char line[4096];
	int tim,val,start;
	int wstart, wpos, bitcount;
	int pos=0;
	int word;
	int dat;

	while(fgets(line,sizeof(line),stdin))
	{
		sscanf(line,"%d %d\n",&tim,&val);
		if (len==0)
			start=tim;
		if (len>=curlen)
		{
			curlen=curlen?(curlen*2):100;
			buff=realloc(buff,curlen*sizeof(buff[0]));
		}
		buff[len]=val;
		len++;
	}
	fprintf(stderr,"got %d samples\n",len);
	dat=1;
	wstart=-1;

	while(pos<len)
	{
		if (buff[pos]<-MAG)
		{
			if ((dat==1) && (wstart<0))
			{
//				fprintf(stderr,"wstart= %d\n",start+pos);
				wstart=pos;
				wpos=wstart+BITLEN/2;
				bitcount=0;
				word=0;
			}
			dat=0;
		}
		if (buff[pos]>MAG)
			dat=1;
		printf("%d %d\n",start+pos,dat*10000);

		if ((wstart>0) && (pos==wpos))
		{
			word=(word>>1)|(dat?0x40:0);
			bitcount++;
			if (bitcount>6)
			{
				fprintf(stderr,"%d   0x%x\n",wstart+start,word);
				word=0;
				bitcount=0;
				wstart=-1;
			}
			else
				wpos+=BITLEN;
		}
		pos++;
	}

	return 0;
}
