#include <msp430x44x.h>
#include <string.h>
#include <stdio.h>

/* $Id: configuration.c,v 1.9 2020/11/11 19:44:15 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
** 
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#define DEFINE
#include "configuration.h"
#undef DEFINE
#include "config.h"
#include "max6682.h"

__attribute__((section(".configsectiona"))) configuration confa[CONFIGURATION_NUM];
__attribute__((section(".configsectionb"))) configuration confb[CONFIGURATION_NUM];

#define WRITEENABLE  {dint(); FCTL3=FWKEY; FCTL1=FWKEY|WRT;}
#define WRITEDISABLE {FCTL1=FWKEY; FCTL3=FWKEY|LOCK; eint();}

/* erases a single page of flash
*/
static void erase(configuration *conf)
{
        int saveintr;

        dint();
        saveintr=IE1;
        IE1=0;

	FCTL3=FWKEY;              /* clear LOCK bit */
	FCTL1=FWKEY | ERASE;      /* set ERASE bit */

	conf->magicnum=0xFF;    /* dummy write...  */

	FCTL1=FWKEY;    /* clear ERASE bit */
	FCTL3=FWKEY | LOCK;   /* set LOCK bit (flash will then be readonly) */

        IE1=saveintr;
        eint();
}

configuration *configuration_get(int num)
{
	if (num>=CONFIGURATION_NUM)
		return NULL;
	if (confa[0].magicnum==CONFIGURATION_VALID)
	{
		return &confa[num];
	}
	if (confb[0].magicnum==CONFIGURATION_VALID)
	{
		return &confb[num];
	}
	return NULL;
}

void configuration_load(int num)
{
	int i;
	configuration *c;

	FCTL2=FWKEY | FSSEL_2 | FN4;   /* FSSEL_2 is select MCLCK, and FN4 is divide by 16+1.  For MSP430-449, the safe range is 257 to 476 KHz  */

	c=configuration_get(num);
	if (c)
	{
		curconfig=*c;
		return;
	}

	writeStrLong("Formatting Configuration Flash\r\n");

	erase(confa);

	curconfig.magicnum=CONFIGURATION_VALID;
	curconfig.decision=0x16f4;
	curconfig.risejitter=0x2000;
	curconfig.qswitchneg=0;
	curconfig.offset[0]=0xf00;
#if NUMDRIVERS>0
	curconfig.offset[1]=0xe00;
#endif
#if NUMDRIVERS>1
	curconfig.offset[2]=0x1800;
#endif
	curconfig.fineoffset=0x100;
	curconfig.lampflags=0x0F;   // trigger and 3 lamps
	curconfig.voltage=3200;
	curconfig.current=5000;

	max6682Set(0,3010);
	max6682Set(1,3010);
	max6682Set(2,3010);

        WRITEENABLE
	i=0;
	{
		confa[i]=curconfig;
	}
        WRITEDISABLE

	curconfig=confa[num];
}

/* We save a config by erasing the /other/ config block,
** then copying all the current configurations from the current
** block to the new block, except for the new config,
** which we copy from the passed in configuration.
*/
int configuration_saveconfig(configuration *conf, int num)
{
	configuration *targ=NULL,*src=NULL;
	int i;

	if (num>=CONFIGURATION_NUM)
		return 1;

	if (confa[0].magicnum==CONFIGURATION_VALID)
	{
		targ=confb;
		src=confa;
	}
	if (confb[0].magicnum==CONFIGURATION_VALID)
	{
		targ=confa;
		src=confb;
	}

	if (targ==NULL)     /* sanity fail...   */
		return 1;

	erase(targ);

        WRITEENABLE

	for(i=0;i<CONFIGURATION_NUM;i++)
		if (i!=num)
			targ[i]=src[i];
		else
			targ[i]=*conf;

	src[0].magicnum=0;
        WRITEDISABLE

	return 0;
}

void configuration_show(configuration *conf)
{
}
