#ifndef IMAGE_H
#define IMAGE_H

/* Copyright 2008 Tommy Johnson
*/

typedef struct Image
{
	int width, height;
	int bpp;
	unsigned char *data;
} Image;

/* returns a ptr to the requested row
*/
unsigned char *imageRow(Image *img, int row);

/* Read an image from a file.  (PPM P6 format)
*/
Image *imageRead(char *fname);

/* Read an image from a FILE
*/
Image *imageReadFD(FILE *fd);


/* write an image to a file. (PPM P6 format)
** returns non-zero if error
*/
int imageWrite(Image *src, char *fname);

/* Create a blank image.  (the data will actualy be uninited... call ImageSet
*/
Image *imageCreate(int width, int height, int bpp);

/* Set a region of an image to a given color
*/
void imageSet(Image *dst, int r, int g, int b, int x1, int y1, int x2, int y2);

/* Copy a region of one image to another image
*/
void imageBlit(Image *dst, Image *src,int xdst, int ydst, int x1, int y1, int x2, int y2);

void imageFree(Image *img);

#endif
