
/* $Id: amp0.h,v 1.11 2018/02/16 21:19:55 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#ifndef AMP0_H
#define AMP0_H

void amp0_init(void);

/* set or clear charge enable
*/
int amp0_enable_get(void);

int amp0_chargetime(void);
void amp0_maxchargetimeset(unsigned int);

void amp0_enable_set(int);

/* returns true when the charger has achieved its set point
*/
int amp0_ready();

/* Set the raw dac value
*/
int amp0_dacset(int dv);

/* set the voltage set point
*/
int amp0_voltageset(int v);

/* read the current set point
*/
int amp0_voltageget(void);

/* read the current voltage
*/
int amp0_voltageread(void);

int amp0_energyread(void);

/* Returns true on the rising edge of the ready flag
*/
int amp0_readycheck(void);

/* Returns true of the energy control module has power applied
*/
int amp0_power_get(void);


#endif
