#ifndef PSMONITOR_H
#define PSMONITOR_H

/* $Id: adc.h,v 1.6 2018/02/16 21:19:55 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
** 
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/



#ifdef DEFINE
#define extern 
#else
#define extern extern
#endif

#undef extern

/* call on startup, for hardware init 
*/
void adc_init(void);

void adc_show(void);

/* Trigger an A to D conversion
*/
void adc_convert(void);

/* Read the last conversion, in millivolts
*/
int adc_read(int chan);

/* Read the last conversion, in ADC units
*/
int adc_readraw(int chan);

/* This is the voltage divider ratio for the
** PD2000 voltage divider  (20M and 33K)
** from milivolts.
*/
// #define PD2000_RATIO 1.64728198472520341
#define PD2000_RATIO 2.2853368560	

#endif
