#include "config.h"
#include <string.h>
#include <stdio.h>

/* $Id: adc.c,v 1.11 2017/12/31 03:51:59 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
** 
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#include "cli.h"
#define DEFINE
#include "adc.h"
#undef DEFINE

void adc_init(void)
{
        ADC12CTL1=
                CONSEQ_1 |        /* sequence of channels, converted once  */
//                ADC12SSEL_3 |     /* src clock is SMCLOCK  */
                ADC12SSEL_0 |     /* src clock is internal */
                ADC12DIV_2  |     /* Divided by 2  */
                CSTARTADD_0 |     /* First register  */
                SHS_0 |           /* sample clock is by setting ADC12SC  */
                SHP |              /* conversion starts on sample clock */
		0
                ;
                
                ;
        ADC12CTL0=
                ADC12ON |
                REFON |			
		REF2_5V |		/* ref== 2.5V  */
                SHT0_8 | SHT1_8 |	/* sample time is 8*4 ADC12CLK ticks */
		MSC |			/* multiple sample conversion  */
		0
                ;

        ADC12MCTL0=
                INCH_0 |     /* input channel  */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL1=
                INCH_1 |     /* input channel   */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL2=
                INCH_2 |     /* input channel   */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL3=
                INCH_3 |     /* input channel   */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL4=
                INCH_4 |     /* input channel   */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL5=
                INCH_5 |     /* input channel    */
                SREF_1      /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL6=
                INCH_6 |     /* input channel   */
                SREF_1      /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL7=
                INCH_7 |     /* input channel   */
                SREF_1      /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL8=
                INCH_8 |     /* input channel   */
                SREF_1      /* ref+ is vref  ref- is Vss  */
                ;


        ADC12MCTL9=
                INCH_10 |     /* input channel temperature */
                SREF_1      /* ref+ is vref  ref- is Vss  */
                ;

        ADC12MCTL10=
                INCH_11 |     /* input channel vcc/2  */
                SREF_1 |     /* ref+ is vref  ref- is Vss  */
                EOS             /* end of sequence */
                ;

//        ADC12IE=1<<5;   /* interupt enable on memory 5  */

        ADC12CTL0|=ENC;   /* last thing is set enable  */
}

void adc_convert(void)
{
	int i;
	ADC12CTL0|=ADC12SC;
	i=0;
	while ((ADC12CTL1 & ADC12BUSY) && (i<0x7FFF))
	{
		i++;
		delay(100);
	}

	if (i>=0x7FFF)
	{
		writeStrLong("ADC took too long\r\n");
	}
}

#define ADC15TOMVOLT(x)   ((x)*0.3662109)
#define ADC25TOMVOLT(x)   ((x)*0.6103515)


int adc_read(int chan)
{
	unsigned int v;
	v=*(&ADC12MEM0+chan);

	return (int)ADC25TOMVOLT(v);
}

int adc_readraw(int chan)
{
	unsigned int v;
	v=*(&ADC12MEM0+chan);

	return v;
}

void adc_show(void)
{
	unsigned int v,i;
	char buff[32];
	double hv;

	adc_convert();

/*
	Vref is 1.5 or 2.5 V.  

	so 1 bit is .0036621090 ma of output.

	temp is 3.55 mv per degree K, and 986 mv at 273 degrees K
*/

#if 1
	for(i=0;i<8;i++)
	{
		v=*(&ADC12MEM0+i);
		snprintf(buff,sizeof(buff),"input %d val 0x%x %d mV\r\n",i,v,(int)ADC25TOMVOLT(v));
		writeStrLong(buff);
	}
#endif
	
	i=273 +   (((ADC25TOMVOLT(ADC12MEM9))- 986.0)/ 3.55);
	snprintf(buff,sizeof(buff),"temp: %d K\r\n",i);
	writeStrLong(buff);

	i=ADC25TOMVOLT(ADC12MEM10)*2.0;
	snprintf(buff,sizeof(buff),"vcc: %d mV\r\n",i);
	writeStrLong(buff);

	i=ADC25TOMVOLT(ADC12MEM1);
	hv=i*7.66666666;
	v=hv;
	snprintf(buff,sizeof(buff),"+15V: %d mV (raw %d mV)\r\n",v,i);
	writeStrLong(buff);

	i=ADC25TOMVOLT(ADC12MEM0);
	v= i*0.7674 / 0.23253;

	snprintf(buff,sizeof(buff),"-15V: %d mV  (raw %d mV)\r\n",v,i);
	writeStrLong(buff);

	snprintf(buff,sizeof(buff),"&buff= %p\r\n",&buff);
	writeStrLong(buff);
}

interrupt (ADC_VECTOR) adcIsr(void)
{
}
