#!/usr/bin/env python
#

import lathe

ID=0.136   #  #29 drill bit, tap for #8-32  must match actual drill in chuck
len=0.75+1/8.0    # includes cutoff tool kerf
OD=0.5

zoffset=2.0

l=lathe.lathe("power_standoff")

l.cutfeed=50.0
l.finishfeed=1.0
l.xstep=0.050   # 50 mils for PVC?   was 0.035
l.zstep=0.010
l.clearance=0.01
l.spindle(0, lathe.COUNTERCLOCKWISE)


l.toolchange(11)   # cut OD, towards chuck

l.moveabs(OD,len+l.clearance+zoffset)
l.prompt("position stock so its < 1/10 from tool");


l.moveabs(OD+l.clearance,len+l.clearance+zoffset)
l.spindle(1000, lathe.COUNTERCLOCKWISE)
l.faceIn(-0.05, len+zoffset)

l.moveabs(0.0,len+l.clearance+zoffset)

l.toolchange(8)
l.moveabs(0.0, len+zoffset+1.0)
l.moveabs(0.0, len+zoffset)

l.spindle(300, lathe.COUNTERCLOCKWISE)
l.cutfeed=10.0
l.drill(zoffset-ID, 0.100)
l.moveabs(0.0, len+zoffset+1.0)


# cutoff tool
l.toolchange(2)   # tool which pokes to the left

l.moveabs(OD+l.clearance, zoffset)
l.cutoff(0.0);
l.moveabs(OD+l.clearance, zoffset)
l.park()

l.done(True)
