#!/usr/bin/env python

import math

if (False):	# 3/4 carbide end mill
	diameter=3/4.0
	numteeth=4.0

	sfm=200.0		# surface feet per minute
	ipt=0.0005		# inches per tooth. Chip load

if (True):	# 3/8 carbide end mill
	diameter=3/8.0
	numteeth=4.0

	# stainless
	sfm=200.0		# surface feet per minute
	ipt=0.0005		# inches per tooth. Chip load

	# aluminum
	sfm=600.0		# surface feet per minute
	ipt=0.0020		# inches per tooth. Chip load

if (False):	# 3/16 carbide end mill
	diameter=3/16.0
	numteeth=4.0

	sfm=200.0		# surface feet per minute
	ipt=0.0005		# inches per tooth. Chip load


if (False):	# approx #32 HSS drill bit

	diameter=0.11
	numteeth=2.0

	sfm=20.0		# surface feet per minute
	ipt=0.001		# inches per tooth. Chip load

if (False):	# approx #18 HSS drill bit

	diameter=0.169
	numteeth=2.0

	sfm=20.0		# surface feet per minute
	ipt=0.001		# inches per tooth. Chip load


circum=diameter*math.pi

rpm=sfm*12.0 / circum
if (rpm>2000.0):
	print("Desired RPM %f,  stomping to 2000 because it doesn't go that fast"%(rpm));
	rpm=2000.0

feed=rpm*ipt*numteeth


print("RPM: %f"%(rpm));
print("Feed: %f inches/minute  %f mm/minute"%(feed, feed*25.4))
